package com.biz.crm.cps.business.activity.scan.local.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.cps.business.common.local.entity.BaseIdEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import javax.persistence.Index;
import lombok.Data;
import lombok.EqualsAndHashCode;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;

/**
 * 扫码活动物料范围明细(ScanActivityProductScopeItem)实体类
 *
 * @author sunx
 * @since 2022-02-16 16:39:05
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Entity
@TableName("scan_activity_product_scope_item")
@Table(
    name = "scan_activity_product_scope_item",
    indexes = {@Index(name = "index1", columnList = "act_code,material_code", unique = true)})
@ApiModel(value = "ScanActivityProductScopeItem", description = "扫码活动物料范围明细")
@org.hibernate.annotations.Table(
    appliesTo = "scan_activity_product_scope_item",
    comment = "扫码活动物料范围明细")
public class ScanActivityProductScopeItem extends BaseIdEntity {

  /** 活动编码 */
  @ApiModelProperty("活动编码")
  @TableField(value = "act_code")
  @Column(name = "act_code", length = 64, columnDefinition = "varchar(64) COMMENT '活动编码'")
  private String actCode;

  /** 物料编码 */
  @ApiModelProperty("物料编码")
  @TableField(value = "material_code")
  @Column(name = "material_code", length = 64, columnDefinition = "varchar(64) COMMENT '物料编码'")
  private String materialCode;
}
