package com.biz.crm.cps.business.activity.scan.local.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.cps.business.common.local.entity.BaseIdEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import javax.persistence.Transient;
import java.util.List;

/**
 * 扫码活动返利奖励配置信息(ScanActivityRebate)实体类
 *
 * @author sunx
 * @since 2022-02-16 16:39:06
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Entity
@TableName("scan_activity_rebate")
@Table(name = "scan_activity_rebate")
@ApiModel(value = "ScanActivityRebate", description = "扫码活动返利奖励配置信息")
@org.hibernate.annotations.Table(appliesTo = "scan_activity_rebate", comment = "扫码活动返利奖励配置信息")
public class ScanActivityRebate extends BaseIdEntity {

  /** 活动编码 */
  @ApiModelProperty("活动编码")
  @TableField(value = "act_code")
  @Column(name = "act_code", length = 64, columnDefinition = "varchar(64) COMMENT '活动编码'")
  private String actCode;

  /** 奖励配置编码 */
  @ApiModelProperty("奖励配置编码")
  @TableField(value = "reward_code")
  @Column(name = "reward_code", length = 64, columnDefinition = "varchar(64) COMMENT '奖励配置编码'")
  private String rewardCode;

  /** 返利奖励配置编码 */
  @ApiModelProperty("返利奖励配置编码")
  @TableField(value = "rebate_code")
  @Column(name = "rebate_code", length = 64, columnDefinition = "varchar(64) COMMENT '返利奖励配置编码'")
  private String rebateCode;

  /** 对象类型 ScanActivityRebateObjTypeEnum */
  @ApiModelProperty("对象类型，customer-经销商、terminal-终端")
  @TableField(value = "obj_type")
  @Column(name = "obj_type", length = 64, columnDefinition = "varchar(64) COMMENT '奖励类型'")
  private String objType;

  /** 奖励类型 ScanActivityRewardTypeEnum */
  @ApiModelProperty("奖励类型，red_packet-红包，point-积分，fee-费用")
  @TableField(value = "reward_type")
  @Column(name = "reward_type", length = 64, columnDefinition = "varchar(64) COMMENT '奖励类型'")
  private String rewardType;

  /** 是否随机 */
  @ApiModelProperty("是否随机")
  @TableField(value = "random_flag")
  @Column(name = "random_flag", columnDefinition = "bit(1) COMMENT '是否随机'")
  private Boolean randomFlag;

  /** 排序 */
  @ApiModelProperty("排序")
  @TableField(value = "sort")
  @Column(name = "sort", length = 11, columnDefinition = "int(11) COMMENT '排序'")
  private Integer sort;

  /** 返利明细配置 */
  @ApiModelProperty("返利明细配置")
  @TableField(exist = false)
  @Transient
  private List<ScanActivityRebate> rebateList;
}
