package com.biz.crm.cps.business.activity.scan.local.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.cps.business.common.local.entity.BaseIdEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import java.math.BigDecimal;

/**
 * 扫码活动返利奖励概率配置信息(ScanActivityRebateValue)实体类
 *
 * @author sunx
 * @since 2022-02-16 16:39:07
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Entity
@TableName("scan_activity_rebate_value")
@Table(name = "scan_activity_rebate_value")
@ApiModel(value = "ScanActivityRebateValue", description = "扫码活动返利奖励概率配置信息")
@org.hibernate.annotations.Table(
    appliesTo = "scan_activity_rebate_value",
    comment = "扫码活动返利奖励概率配置信息")
public class ScanActivityRebateValue extends BaseIdEntity {

  /** 活动编码 */
  @ApiModelProperty("活动编码")
  @TableField(value = "act_code")
  @Column(name = "act_code", length = 64, columnDefinition = "varchar(64) COMMENT '活动编码'")
  private String actCode;

  /** 返利奖励编码 */
  @ApiModelProperty("返利奖励编码")
  @TableField(value = "rebate_code")
  @Column(name = "rebate_code", length = 64, columnDefinition = "varchar(64) COMMENT '返利奖励编码'")
  private String rebateCode;

  /** 概率 */
  @ApiModelProperty("概率")
  @TableField(value = "rate")
  @Column(name = "rate", columnDefinition = "decimal(20,4) COMMENT '概率'")
  private BigDecimal rate;

  /** 返利值 */
  @ApiModelProperty("返利值")
  @TableField(value = "rebate_value")
  @Column(name = "rebate_value", columnDefinition = "decimal(20,4) COMMENT '返利值'")
  private BigDecimal rebateValue;

  /** 排序 */
  @ApiModelProperty("排序")
  @TableField(value = "sort")
  @Column(name = "sort", length = 11, columnDefinition = "int(11) COMMENT '排序'")
  private Integer sort;
}
