package com.biz.crm.cps.business.activity.scan.local.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.cps.business.common.local.entity.BaseIdEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import java.math.BigDecimal;

/**
 * 扫码活动奖励发放值概率配置信息(ScanActivityRewardValue)实体类
 *
 * @author sunx
 * @since 2022-02-16 16:39:10
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Entity
@TableName("scan_activity_reward_value")
@Table(name = "scan_activity_reward_value")
@ApiModel(value = "ScanActivityRewardValue", description = "扫码活动奖励发放值概率配置信息")
@org.hibernate.annotations.Table(
    appliesTo = "scan_activity_reward_value",
    comment = "扫码活动奖励发放值概率配置信息")
public class ScanActivityRewardValue extends BaseIdEntity {

  /** 活动编码 */
  @ApiModelProperty("活动编码")
  @TableField(value = "act_code")
  @Column(name = "act_code", length = 64, columnDefinition = "varchar(64) COMMENT '活动编码'")
  private String actCode;

  /** 奖励配置编码 */
  @ApiModelProperty("奖励配置编码")
  @TableField(value = "reward_code")
  @Column(name = "reward_code", length = 64, columnDefinition = "varchar(64) COMMENT '奖励配置编码'")
  private String rewardCode;

  /** 概率 */
  @ApiModelProperty("概率")
  @TableField(value = "rate")
  @Column(name = "rate", columnDefinition = "decimal(20,4) COMMENT '概率'")
  private BigDecimal rate;

  /** 奖励值 */
  @ApiModelProperty("奖励值")
  @TableField(value = "reward_value")
  @Column(name = "reward_value", columnDefinition = "decimal(20,4) COMMENT '奖励值'")
  private BigDecimal rewardValue;

  /** 排序 */
  @ApiModelProperty("排序")
  @TableField(value = "sort")
  @Column(name = "sort", length = 11, columnDefinition = "int(11) COMMENT '排序'")
  private Integer sort;
}
