package com.biz.crm.cps.business.activity.scan.local.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.cps.business.common.local.entity.BaseIdEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;

/**
 * 消费者扫码活动参与范围配置信息(ScanActivityUserArea)实体类
 *
 * @author sunx
 * @since 2022-02-16 16:39:03
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Entity
@TableName("scan_activity_user_area")
@Table(name = "scan_activity_user_area")
@ApiModel(value = "ScanActivityUserArea", description = "消费者扫码活动参与范围配置信息")
@org.hibernate.annotations.Table(appliesTo = "scan_activity_user_area", comment = "消费者扫码活动参与范围配置信息")
public class ScanActivityUserArea extends BaseIdEntity {

  /** 活动编码 */
  @ApiModelProperty("活动编码")
  @TableField(value = "act_code")
  @Column(name = "act_code", length = 64, columnDefinition = "varchar(64) COMMENT '活动编码'")
  private String actCode;

  /** 省编码 */
  @ApiModelProperty("省编码")
  @TableField(value = "province_code")
  @Column(name = "province_code", length = 64, columnDefinition = "varchar(64) COMMENT '省编码'")
  private String provinceCode;

  /** 省 */
  @ApiModelProperty("省")
  @TableField(value = "province_name")
  @Column(name = "province_name", length = 64, columnDefinition = "varchar(64) COMMENT '省'")
  private String provinceName;

  /** 市编码 */
  @ApiModelProperty("市编码")
  @TableField(value = "city_code")
  @Column(name = "city_code", length = 64, columnDefinition = "varchar(64) COMMENT '市编码'")
  private String cityCode;

  /** 市 */
  @ApiModelProperty("市")
  @TableField(value = "city_name")
  @Column(name = "city_name", length = 64, columnDefinition = "varchar(64) COMMENT '市'")
  private String cityName;

  /** 排序 */
  @ApiModelProperty("排序")
  @TableField(value = "sort")
  @Column(name = "sort", length = 11, columnDefinition = "int(11) COMMENT '排序'")
  private Integer sort;
}
