package com.biz.crm.cps.business.activity.scan.local.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.cps.business.common.local.entity.BaseIdEntity;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Date;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.springframework.format.annotation.DateTimeFormat;

/**
 * 扫码活动人员关联关系信息(ScanActivityUserScopeItem)实体类
 *
 * @author sunx
 * @since 2022-02-16 16:39:12
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Entity
@TableName("scan_activity_user_scope_item")
@Table(
    name = "scan_activity_user_scope_item",
    indexes = {
      @Index(
          name = "scan_activity_user_scope_item_index1",
          unique = true,
          columnList = "participate_obj,act_code,user_code"),
    })
@ApiModel(value = "ScanActivityUserScopeItem", description = "扫码活动人员关联关系信息")
@org.hibernate.annotations.Table(
    appliesTo = "scan_activity_user_scope_item",
    comment = "扫码活动人员关联关系信息")
public class ScanActivityUserScopeItem extends BaseIdEntity {

  /** 参与对象 */
  @ApiModelProperty("参与对象")
  @TableField(value = "participate_obj")
  @Column(name = "participate_obj", length = 64, columnDefinition = "varchar(64) COMMENT '参与对象'")
  private String participateObj;

  /** 活动编码 */
  @ApiModelProperty("活动编码")
  @TableField(value = "act_code")
  @Column(name = "act_code", length = 64, columnDefinition = "varchar(64) COMMENT '活动编码'")
  private String actCode;

  /** 参与对象编码 */
  @ApiModelProperty("参与对象编码")
  @TableField(value = "user_code")
  @Column(name = "user_code", length = 64, columnDefinition = "varchar(64) COMMENT '参与对象编码'")
  private String userCode;

  /** 是否已参与 */
  @ApiModelProperty("是否已参与")
  @TableField(value = "join_flag")
  @Column(name = "join_flag", columnDefinition = "bit(1) COMMENT '是否随机'")
  private Boolean joinFlag;

  /** 参与时间 */
  @ApiModelProperty("参与时间")
  @TableField(value = "create_time")
  @Column(name = "create_time", length = -1, columnDefinition = "datetime COMMENT '参与时间'")
  @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
  @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private Date createTime;
}
