package com.biz.crm.cps.business.activity.scan.local.mapper;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.cps.business.activity.scan.sdk.dto.ScanActivityListPaginationDto;
import com.biz.crm.cps.business.activity.scan.sdk.vo.ScanActivityListVo;
import org.apache.ibatis.annotations.Param;

/**
 * 扫码活动前端分页
 *
 * @author sunx
 * @date 2022/3/29
 */
public interface ScanActivityListVoMapper {

  /**
   * 前端列表分页查询
   *
   * @param page
   * @param dto
   * @return
   */
  Page<ScanActivityListVo> findListByConditions(
      Page<ScanActivityListVo> page, @Param("dto") ScanActivityListPaginationDto dto);

  /**
   * 前端列表分页查询(待参与)
   *
   * @param page
   * @param dto
   * @return
   */
  Page<ScanActivityListVo> findDefaultListByConditions(
      Page<ScanActivityListVo> page, @Param("dto") ScanActivityListPaginationDto dto);

  /**
   * 前端列表分页查询(已参与)
   *
   * @param page
   * @param dto
   * @return
   */
  Page<ScanActivityListVo> findParticipateListByConditions(
      Page<ScanActivityListVo> page, @Param("dto") ScanActivityListPaginationDto dto);

  /**
   * 前端列表分页查询(已过期)
   *
   * @param page
   * @param dto
   * @return
   */
  Page<ScanActivityListVo> findOverdueListByConditions(
      Page<ScanActivityListVo> page, @Param("dto") ScanActivityListPaginationDto dto);
}
