package com.biz.crm.cps.business.activity.scan.local.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.cps.business.activity.scan.local.entity.ScanActivity;
import com.biz.crm.cps.business.activity.scan.sdk.dto.ScanActivityPaginationDto;
import java.util.Date;
import java.util.List;
import org.apache.ibatis.annotations.Param;

/**
 * 扫码活动(ScanActivity)表数据库访问层
 *
 * @author sunx
 * @date 2022-02-16 16:39:00
 */
public interface ScanActivityMapper extends BaseMapper<ScanActivity> {

  /**
   * 分页列表
   *
   * @param page 分页信息
   * @param dto 分页参数dto
   * @return 分页列表
   */
  Page<ScanActivity> findByConditions(
      Page<ScanActivity> page, @Param("dto") ScanActivityPaginationDto dto);

  /**
   * 根据时间区间获取时间区间重叠的启用的同类型活动信息
   *
   * @param startTime
   * @param endTime
   * @param participateObj
   * @param enableStatus
   * @return
   */
  List<ScanActivity> findEnableRepeatByTimeBetweenAndParticipateObj(
      @Param("startTime") Date startTime,
      @Param("endTime") Date endTime,
      @Param("participateObj") String participateObj,
      @Param("enableStatus") String enableStatus);
}
