package com.biz.crm.cps.business.activity.scan.local.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.cps.business.activity.scan.local.entity.ScanActivityProductScopeItem;
import com.biz.crm.cps.business.activity.scan.sdk.dto.ScanActivityProductScopeItemPaginationDto;
import java.util.Set;
import org.apache.ibatis.annotations.Param;

/**
 * 扫码活动物料范围明细(ScanActivityProductScopeItem)表数据库访问层
 *
 * @author sunx
 * @date 2022-02-16 16:39:05
 */
public interface ScanActivityProductScopeItemMapper
    extends BaseMapper<ScanActivityProductScopeItem> {

  /**
   * 根据既有活动编码集合获取包含对应物料编码集合的活动编码数据
   *
   * @param actCodeSet
   * @param materialCodeSet
   * @return
   */
  Set<String> findProductScopeItemActCodeSet(
      @Param("list1") Set<String> actCodeSet, @Param("list2") Set<String> materialCodeSet);

  /**
   * 分页
   *
   * @param page
   * @param dto
   * @return
   */
  Page<ScanActivityProductScopeItem> findByConditions(
      Page<ScanActivityProductScopeItem> page,
      @Param("dto") ScanActivityProductScopeItemPaginationDto dto);
}
