package com.biz.crm.cps.business.activity.scan.local.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.cps.business.activity.scan.local.entity.ScanActivityUserScopeItem;
import com.biz.crm.cps.business.activity.scan.sdk.dto.ScanActivityUserScopeItemPaginationDto;
import java.util.Set;
import org.apache.ibatis.annotations.Param;

/**
 * 扫码活动人员关联关系信息(ScanActivityUserScopeItem)表数据库访问层
 *
 * @author sunx
 * @date 2022-02-16 16:39:13
 */
public interface ScanActivityUserScopeItemMapper extends BaseMapper<ScanActivityUserScopeItem> {

  /**
   * 根据既有活动编码集合获取包含对应参与者的集合的活动编码数据
   *
   * @param participateObj
   * @param actCodeSet
   * @param userCodeSet
   * @return
   */
  Set<String> findUserScopeItemActCodeSet(
      @Param("participateObj") String participateObj,
      @Param("list1") Set<String> actCodeSet,
      @Param("list2") Set<String> userCodeSet);

  /**
   * 分页
   *
   * @param page
   * @param dto
   * @return
   */
  Page<ScanActivityUserScopeItem> findByConditions(
      Page<ScanActivityUserScopeItem> page,
      @Param("dto") ScanActivityUserScopeItemPaginationDto dto);

  /**
   * 根据参与类型+参与对象编码获取已参与且正在执行的活动编码集合
   *
   * @param participateObj
   * @param userCode
   * @param delFlag
   * @param enableStatus
   * @param participateType
   * @param participateScope
   * @param joinFlag
   * @return
   */
  Set<String> findCurExecActCodeSetByParticipateObjAndUserCode(
      @Param("participateObj") String participateObj,
      @Param("userCode") String userCode,
      @Param("delFlag") String delFlag,
      @Param("enableStatus") String enableStatus,
      @Param("participateType") String participateType,
      @Param("participateScope") String participateScope,
      @Param("joinFlag") Boolean joinFlag);
}
