package com.biz.crm.cps.business.activity.scan.local.repository;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.cps.business.activity.scan.local.mapper.ScanActivityListVoMapper;
import com.biz.crm.cps.business.activity.scan.sdk.dto.ScanActivityListPaginationDto;
import com.biz.crm.cps.business.activity.scan.sdk.vo.ScanActivityListVo;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

/**
 * 扫码活动前端分页
 *
 * @author sunx
 * @date 2022/3/29
 */
@Component
public class ScanActivityListVoRepository {
  @Autowired private ScanActivityListVoMapper scanActivityListVoMapper;

  /**
   * 前端列表分页查询
   *
   * @param page
   * @param dto
   * @return
   */
  public Page<ScanActivityListVo> findListByConditions(
      Page<ScanActivityListVo> page, ScanActivityListPaginationDto dto) {
    return this.scanActivityListVoMapper.findListByConditions(page, dto);
  }

  /**
   * 前端列表分页查询(待参与)
   *
   * @param page
   * @param dto
   * @return
   */
  public Page<ScanActivityListVo> findDefaultListByConditions(
      Page<ScanActivityListVo> page, ScanActivityListPaginationDto dto) {
    return this.scanActivityListVoMapper.findDefaultListByConditions(page, dto);
  }

  /**
   * 前端列表分页查询(已参与)
   *
   * @param page
   * @param dto
   * @return
   */
  public Page<ScanActivityListVo> findParticipateListByConditions(
      Page<ScanActivityListVo> page, ScanActivityListPaginationDto dto) {
    return this.scanActivityListVoMapper.findParticipateListByConditions(page, dto);
  }

  /**
   * 前端列表分页查询(过期)
   *
   * @param page
   * @param dto
   * @return
   */
  public Page<ScanActivityListVo> findOverdueListByConditions(
      Page<ScanActivityListVo> page, ScanActivityListPaginationDto dto) {
    return this.scanActivityListVoMapper.findOverdueListByConditions(page, dto);
  }
}
