package com.biz.crm.cps.business.activity.scan.local.repository;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.cps.business.activity.scan.local.entity.ScanActivityParticipateScope;
import com.biz.crm.cps.business.activity.scan.local.mapper.ScanActivityParticipateScopeMapper;
import java.util.List;
import java.util.Set;
import org.springframework.stereotype.Component;

/**
 * 扫码活动参与范围(repository)
 *
 * @author sunx
 * @date 2022/2/22
 */
@Component
public class ScanActivityParticipateScopeRepository
    extends ServiceImpl<ScanActivityParticipateScopeMapper, ScanActivityParticipateScope> {

  /**
   * 根据活动编码删除关联数据
   *
   * @param actCode
   */
  public void deleteByActCode(String actCode) {
    LambdaQueryWrapper<ScanActivityParticipateScope> lambdaQuery = Wrappers.lambdaQuery();
    lambdaQuery.eq(ScanActivityParticipateScope::getActCode, actCode);
    baseMapper.delete(lambdaQuery);
  }

  /**
   * 根据活动编码获取关联的数据信息
   *
   * @param actCodeSet
   * @return
   */
  public List<ScanActivityParticipateScope> findByActCodes(Set<String> actCodeSet) {
    return this.lambdaQuery()
        .in(ScanActivityParticipateScope::getActCode, actCodeSet)
        .orderByAsc(ScanActivityParticipateScope::getActCode)
        .orderByAsc(ScanActivityParticipateScope::getSort)
        .list();
  }
}
