package com.biz.crm.cps.business.activity.scan.local.repository;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.cps.business.activity.scan.local.entity.ScanActivity;
import com.biz.crm.cps.business.activity.scan.local.entity.ScanActivityProductScopeItem;
import com.biz.crm.cps.business.activity.scan.local.mapper.ScanActivityProductScopeItemMapper;
import com.biz.crm.cps.business.activity.scan.sdk.dto.ScanActivityProductScopeItemPaginationDto;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.springframework.stereotype.Component;

/**
 * 扫码活动物料范围明细(repository)
 *
 * @author sunx
 * @date 2022-02-16 16:39:05
 */
@Component
public class ScanActivityProductScopeItemRepository
    extends ServiceImpl<ScanActivityProductScopeItemMapper, ScanActivityProductScopeItem> {

  /**
   * 分页查询
   *
   * @param page
   * @param dto
   * @return
   */
  public Page<ScanActivityProductScopeItem> findByConditions(
      Page<ScanActivityProductScopeItem> page, ScanActivityProductScopeItemPaginationDto dto) {
    return baseMapper.findByConditions(page, dto);
  }

  /**
   * 根据活动编码删除关联数据
   *
   * @param actCode
   */
  public void deleteByActCode(String actCode) {
    LambdaQueryWrapper<ScanActivityProductScopeItem> lambdaQuery = Wrappers.lambdaQuery();
    lambdaQuery.eq(ScanActivityProductScopeItem::getActCode, actCode);
    baseMapper.delete(lambdaQuery);
  }

  /**
   * 根据活动编码获取关联的数据信息
   *
   * @param actCodeSet
   * @return
   */
  public List<ScanActivityProductScopeItem> findByActCodes(Set<String> actCodeSet) {
    return this.lambdaQuery()
        .in(ScanActivityProductScopeItem::getActCode, actCodeSet)
        .orderByAsc(ScanActivityProductScopeItem::getActCode)
        .list();
  }

  /**
   * 根据既有活动编码集合获取包含对应物料编码集合的活动编码数据
   *
   * @param actCodeSet
   * @param materialCodeSet
   * @return
   */
  public Set<String> findProductScopeItemActCodeSet(
      Set<String> actCodeSet, Set<String> materialCodeSet) {
    return this.baseMapper.findProductScopeItemActCodeSet(actCodeSet, materialCodeSet);
  }
}
