package com.biz.crm.cps.business.activity.scan.local.repository;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.cps.business.activity.scan.local.entity.ScanActivityProductScope;
import com.biz.crm.cps.business.activity.scan.local.mapper.ScanActivityProductScopeMapper;
import java.util.List;
import org.springframework.stereotype.Component;

/**
 * 扫码活动物料范围配置信息(repository)
 *
 * @author sunx
 * @date 2022-02-16 16:39:04
 */
@Component
public class ScanActivityProductScopeRepository
    extends ServiceImpl<ScanActivityProductScopeMapper, ScanActivityProductScope> {

  /**
   * 根据活动编码删除物料配置信息
   *
   * @param actCode
   */
  public void deleteByActCode(String actCode) {
    LambdaQueryWrapper<ScanActivityProductScope> lambdaQuery = Wrappers.lambdaQuery();
    lambdaQuery.eq(ScanActivityProductScope::getActCode, actCode);
    baseMapper.delete(lambdaQuery);
  }

  /**
   * 根据活动编码获取物料配置信息
   *
   * @param actCode
   * @return
   */
  public List<ScanActivityProductScope> findByActCode(String actCode) {
    return lambdaQuery()
        .eq(ScanActivityProductScope::getActCode, actCode)
        .orderByAsc(ScanActivityProductScope::getSort)
        .list();
  }
}
