package com.biz.crm.cps.business.activity.scan.local.repository;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.cps.business.activity.scan.local.entity.ScanActivityRebate;
import com.biz.crm.cps.business.activity.scan.local.mapper.ScanActivityRebateMapper;
import java.util.List;
import org.springframework.stereotype.Component;

/**
 * 扫码活动返利奖励配置信息(repository)
 *
 * @author sunx
 * @date 2022-02-16 16:39:06
 */
@Component
public class ScanActivityRebateRepository
    extends ServiceImpl<ScanActivityRebateMapper, ScanActivityRebate> {

  /**
   * 根据扫码活动编码删除数据
   *
   * @param actCode
   */
  public void deleteByActCode(String actCode) {
    LambdaQueryWrapper<ScanActivityRebate> lambdaQuery = Wrappers.lambdaQuery();
    lambdaQuery.eq(ScanActivityRebate::getActCode, actCode);
    baseMapper.delete(lambdaQuery);
  }

  /**
   * 根据活动编码获取详情信息
   *
   * @param actCode
   * @return
   */
  public List<ScanActivityRebate> findByActCode(String actCode) {
    return lambdaQuery()
        .eq(ScanActivityRebate::getActCode, actCode)
        .orderByAsc(ScanActivityRebate::getSort)
        .list();
  }
}
