package com.biz.crm.cps.business.activity.scan.local.repository;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.cps.business.activity.scan.local.entity.ScanActivityRebateValue;
import com.biz.crm.cps.business.activity.scan.local.mapper.ScanActivityRebateValueMapper;
import java.util.List;
import org.springframework.stereotype.Component;

/**
 * 扫码活动返利奖励概率配置信息(repository)
 *
 * @author sunx
 * @date 2022-02-16 16:39:08
 */
@Component
public class ScanActivityRebateValueRepository
    extends ServiceImpl<ScanActivityRebateValueMapper, ScanActivityRebateValue> {

  /**
   * 根据扫码活动编码删除数据
   *
   * @param actCode
   */
  public void deleteByActCode(String actCode) {
    LambdaQueryWrapper<ScanActivityRebateValue> lambdaQuery = Wrappers.lambdaQuery();
    lambdaQuery.eq(ScanActivityRebateValue::getActCode, actCode);
    baseMapper.delete(lambdaQuery);
  }

  /**
   * 根据活动编码获取详情信息
   *
   * @param actCode
   * @return
   */
  public List<ScanActivityRebateValue> findByActCode(String actCode) {
    return lambdaQuery()
        .eq(ScanActivityRebateValue::getActCode, actCode)
        .orderByAsc(ScanActivityRebateValue::getSort)
        .list();
  }
}
