package com.biz.crm.cps.business.activity.scan.local.repository;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.cps.business.activity.scan.local.entity.ScanActivity;
import com.biz.crm.cps.business.activity.scan.local.mapper.ScanActivityMapper;
import com.biz.crm.cps.business.activity.scan.sdk.dto.ScanActivityPaginationDto;
import com.biz.crm.cps.business.common.sdk.enums.EnableStatusEnum;
import java.util.Date;
import java.util.List;
import java.util.Set;
import org.springframework.stereotype.Component;

/**
 * 扫码活动(repository)
 *
 * @author sunx
 * @date 2022-02-16 16:39:01
 */
@Component
public class ScanActivityRepository extends ServiceImpl<ScanActivityMapper, ScanActivity> {

  /**
   * 根据活动编码获取活动详情
   *
   * @param codeSet
   * @return
   */
  public List<ScanActivity> findDetailsByCodes(Set<String> codeSet) {
    return this.lambdaQuery().in(ScanActivity::getCode, codeSet).list();
  }

  /**
   * 分页
   *
   * @param page
   * @param dto
   * @return
   */
  public Page<ScanActivity> findByConditions(
      Page<ScanActivity> page, ScanActivityPaginationDto dto) {
    return baseMapper.findByConditions(page, dto);
  }

  /**
   * 根据id集合 更新组织启用/禁用状态
   *
   * @param ids
   * @param enable
   */
  public void updateEnableStatusByIds(List<String> ids, EnableStatusEnum enable) {
    this.lambdaUpdate()
        .in(ScanActivity::getId, ids)
        .set(ScanActivity::getEnableStatus, enable.getCode())
        .update();
  }

  /**
   * 根据时间区间获取时间区间重叠的启用的同类型活动信息
   *
   * @param startTime
   * @param endTime
   * @param participateObj
   * @return
   */
  public List<ScanActivity> findEnableRepeatByTimeBetweenAndParticipateObj(
      Date startTime, Date endTime, String participateObj) {
    return this.baseMapper.findEnableRepeatByTimeBetweenAndParticipateObj(
        startTime, endTime, participateObj, EnableStatusEnum.ENABLE.getCode());
  }
}
