package com.biz.crm.cps.business.activity.scan.local.repository;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.cps.business.activity.scan.local.entity.ScanActivityReward;
import com.biz.crm.cps.business.activity.scan.local.mapper.ScanActivityRewardMapper;
import java.util.List;
import org.springframework.stereotype.Component;

/**
 * 扫码活动奖励规则(repository)
 *
 * @author sunx
 * @date 2022-02-16 16:39:09
 */
@Component
public class ScanActivityRewardRepository
    extends ServiceImpl<ScanActivityRewardMapper, ScanActivityReward> {

  /**
   * 根据扫码活动编码删除数据
   *
   * @param actCode
   */
  public void deleteByActCode(String actCode) {
    LambdaQueryWrapper<ScanActivityReward> lambdaQuery = Wrappers.lambdaQuery();
    lambdaQuery.eq(ScanActivityReward::getActCode, actCode);
    baseMapper.delete(lambdaQuery);
  }

  /**
   * 根据活动编码获取详情信息
   *
   * @param actCode
   * @return
   */
  public List<ScanActivityReward> findByActCode(String actCode) {
    return lambdaQuery()
        .eq(ScanActivityReward::getActCode, actCode)
        .orderByAsc(ScanActivityReward::getSort)
        .list();
  }
}
