package com.biz.crm.cps.business.activity.scan.local.repository;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.cps.business.activity.scan.local.entity.ScanActivityRewardValue;
import com.biz.crm.cps.business.activity.scan.local.mapper.ScanActivityRewardValueMapper;
import java.util.List;
import org.springframework.stereotype.Component;

/**
 * 扫码活动奖励发放值概率配置信息(repository)
 *
 * @author sunx
 * @date 2022-02-16 16:39:10
 */
@Component
public class ScanActivityRewardValueRepository
    extends ServiceImpl<ScanActivityRewardValueMapper, ScanActivityRewardValue> {

  /**
   * 根据扫码活动编码删除数据
   *
   * @param actCode
   */
  public void deleteByActCode(String actCode) {
    LambdaQueryWrapper<ScanActivityRewardValue> lambdaQuery = Wrappers.lambdaQuery();
    lambdaQuery.eq(ScanActivityRewardValue::getActCode, actCode);
    baseMapper.delete(lambdaQuery);
  }

  /**
   * 根据活动编码获取详情信息
   *
   * @param actCode
   * @return
   */
  public List<ScanActivityRewardValue> findByActCode(String actCode) {
    return lambdaQuery()
        .eq(ScanActivityRewardValue::getActCode, actCode)
        .orderByAsc(ScanActivityRewardValue::getSort)
        .list();
  }
}
