package com.biz.crm.cps.business.activity.scan.local.repository;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.cps.business.activity.scan.local.entity.ScanActivityUserArea;
import com.biz.crm.cps.business.activity.scan.local.mapper.ScanActivityUserAreaMapper;
import java.util.List;
import java.util.Set;
import org.apache.ibatis.annotations.Param;
import org.springframework.stereotype.Component;

/**
 * 消费者扫码活动区域配置repository
 *
 * @author sunx
 * @date 2022/3/7
 */
@Component
public class ScanActivityUserAreaRepository
    extends ServiceImpl<ScanActivityUserAreaMapper, ScanActivityUserArea> {

  /**
   * 根据活动编码删除配置信息
   *
   * @param actCode
   */
  public void deleteByActCode(String actCode) {
    LambdaQueryWrapper<ScanActivityUserArea> lambdaQuery = Wrappers.lambdaQuery();
    lambdaQuery.eq(ScanActivityUserArea::getActCode, actCode);
    baseMapper.delete(lambdaQuery);
  }

  /**
   * 根据活动编码获取配置信息
   *
   * @param actCode
   * @return
   */
  public List<ScanActivityUserArea> findByActCode(String actCode) {
    return this.lambdaQuery()
        .eq(ScanActivityUserArea::getActCode, actCode)
        .orderByAsc(ScanActivityUserArea::getActCode)
        .orderByAsc(ScanActivityUserArea::getSort)
        .list();
  }

  /**
   * 省市匹配的活动编码
   *
   * @param provinceName
   * @param cityName
   * @param actCodeSet
   * @return
   */
  public Set<String> findAreaActCodeSetByAreaAndActCodeIn(
      String provinceName, String cityName, Set<String> actCodeSet) {
    return this.baseMapper.findAreaActCodeSetByAreaAndActCodeIn(
        provinceName, cityName, actCodeSet, Boolean.FALSE);
  }
}
