package com.biz.crm.cps.business.activity.scan.local.repository;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.cps.business.activity.scan.local.entity.ScanActivityUserScopeItem;
import com.biz.crm.cps.business.activity.scan.local.mapper.ScanActivityUserScopeItemMapper;
import com.biz.crm.cps.business.activity.scan.sdk.dto.ScanActivityUserScopeItemPaginationDto;
import com.biz.crm.cps.business.activity.scan.sdk.enums.ScanActivityParticipateTypeEnum;
import com.biz.crm.cps.business.activity.scan.sdk.enums.ScanActivityScopeEnum;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.springframework.stereotype.Component;

/**
 * 扫码活动人员关联关系信息(repository)
 *
 * @author sunx
 * @date 2022-02-16 16:39:13
 */
@Component
public class ScanActivityUserScopeItemRepository
    extends ServiceImpl<ScanActivityUserScopeItemMapper, ScanActivityUserScopeItem> {

  /**
   * 分页查询
   *
   * @param page
   * @param dto
   * @return
   */
  public Page<ScanActivityUserScopeItem> findByConditions(
      Page<ScanActivityUserScopeItem> page, ScanActivityUserScopeItemPaginationDto dto) {
    return baseMapper.findByConditions(page, dto);
  }

  /**
   * 根据活动编码删除关联数据
   *
   * @param actCode
   */
  public void deleteByActCode(String actCode) {
    LambdaQueryWrapper<ScanActivityUserScopeItem> lambdaQuery = Wrappers.lambdaQuery();
    lambdaQuery.eq(ScanActivityUserScopeItem::getActCode, actCode);
    baseMapper.delete(lambdaQuery);
  }

  /**
   * 根据活动编码获取关联的数据信息
   *
   * @param actCodeSet
   * @return
   */
  public List<ScanActivityUserScopeItem> findByActCodes(Set<String> actCodeSet) {
    return this.lambdaQuery()
        .in(ScanActivityUserScopeItem::getActCode, actCodeSet)
        .orderByAsc(ScanActivityUserScopeItem::getActCode)
        .list();
  }

  /**
   * 根据既有活动编码集合获取包含对应参与者的集合的活动编码数据
   *
   * @param participateObj
   * @param actCodeSet
   * @param userCodeSet
   * @return
   */
  public Set<String> findUserScopeItemActCodeSet(
      String participateObj, Set<String> actCodeSet, Set<String> userCodeSet) {
    return this.baseMapper.findUserScopeItemActCodeSet(participateObj, actCodeSet, userCodeSet);
  }

  /**
   * 根据参与类型+参与对象编码获取已参与且正在执行的活动编码集合
   *
   * @param participateObj
   * @param userCode
   * @return
   */
  public Set<String> findCurExecActCodeSetByParticipateObjAndUserCode(
      String participateObj, String userCode) {
    return this.baseMapper.findCurExecActCodeSetByParticipateObjAndUserCode(
        participateObj,
        userCode,
        DelFlagStatusEnum.NORMAL.getCode(),
        EnableStatusEnum.ENABLE.getCode(),
        ScanActivityParticipateTypeEnum.AUTOMATIC.getDictCode(),
        ScanActivityScopeEnum.ALL.getDictCode(),
        Boolean.TRUE);
  }

  /**
   * 获取参与详情
   *
   * @param participateObj
   * @param userCode
   * @param joinFlag
   * @param actCodeSet
   * @return
   */
  public List<ScanActivityUserScopeItem> findByParticipateObjAndUserCodeAndJoinFlagAndActCodeIn(
      String participateObj, String userCode, Boolean joinFlag, Set<String> actCodeSet) {
    return this.lambdaQuery()
        .eq(ScanActivityUserScopeItem::getParticipateObj, participateObj)
        .eq(StringUtils.isNotBlank(userCode), ScanActivityUserScopeItem::getUserCode, userCode)
        .eq(Objects.nonNull(joinFlag), ScanActivityUserScopeItem::getJoinFlag, joinFlag)
        .in(ScanActivityUserScopeItem::getActCode, actCodeSet)
        .list();
  }
}
