package com.biz.crm.cps.business.activity.scan.local.service;

import com.biz.crm.cps.business.activity.scan.local.entity.ScanActivityProductScopeItem;
import java.util.List;
import java.util.Set;

/**
 * 扫码活动物料范围明细(ScanActivityProductScopeItem)表服务接口
 *
 * @author sunx
 * @date 2022-02-16 16:39:05
 */
public interface ScanActivityProductScopeItemService {

  /**
   * 保存物料范围明细信息
   *
   * @param list
   * @param actCode
   */
  void createScopeItem(List<ScanActivityProductScopeItem> list, String actCode);

  /**
   * 根据活动编码删除关联数据
   *
   * @param actCode
   */
  void deleteByActCode(String actCode);

  /**
   * 根据既有活动编码集合获取包含对应物料编码集合的活动编码数据
   *
   * @param actCodeSet
   * @param materialCodeSet
   * @return
   */
  Set<String> findProductScopeItemActCodeSet(Set<String> actCodeSet, Set<String> materialCodeSet);

  /**
   * 物料与活动集合存在交集关系的活动编码集合
   *
   * @param materialCode
   * @param actCodeSet
   * @return
   */
  Set<String> findMaterialActCodeSetByMaterialCodeAndActCodeIn(
      String materialCode, Set<String> actCodeSet);
}
