package com.biz.crm.cps.business.activity.scan.local.service;

import com.biz.crm.cps.business.activity.scan.local.entity.ScanActivityProductScope;
import java.util.List;

/**
 * 扫码活动物料范围配置信息(ScanActivityProductScope)表服务接口
 *
 * @author sunx
 * @date 2022-02-16 16:39:04
 */
public interface ScanActivityProductScopeService {

  /**
   * 根据活动编码获取物料配置信息
   *
   * @param actCode
   * @return
   */
  List<ScanActivityProductScope> findByActCode(String actCode);

  /**
   * 保存物料配置信息
   *
   * @param list
   * @param actCode
   */
  void createProductScope(List<ScanActivityProductScope> list, String actCode);
}
