package com.biz.crm.cps.business.activity.scan.local.service;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.cps.business.activity.scan.local.entity.ScanActivity;
import com.biz.crm.cps.business.activity.scan.local.model.dto.ScanActivityCheckRepeatModelDto;
import com.biz.crm.cps.business.activity.scan.sdk.dto.ScanActivityPaginationDto;
import java.util.List;
import java.util.Set;
import org.springframework.data.domain.Pageable;

/**
 * 扫码活动(ScanActivity)表服务接口
 *
 * @author sunx
 * @date 2022-02-16 16:39:01
 */
public interface ScanActivityService {

  /**
   * 分页条件查询
   *
   * @param pageable
   * @param dto
   * @return
   */
  Page<ScanActivity> findByConditions(Pageable pageable, ScanActivityPaginationDto dto);

  /**
   * 按id查询详情
   *
   * @param id
   * @return
   */
  ScanActivity findDetailById(String id);

  /**
   * 根据编码集合获取详情
   *
   * @param codeSet
   * @return
   */
  List<ScanActivity> findDetailByCodes(Set<String> codeSet);

  /**
   * 新增
   *
   * @param scanActivity
   * @return
   */
  ScanActivity create(ScanActivity scanActivity);

  /**
   * 编辑
   *
   * @param scanActivity
   * @return
   */
  ScanActivity update(ScanActivity scanActivity);

  /**
   * 按id启用
   *
   * @param id
   */
  void enable(String id);

  /**
   * 按id禁用
   *
   * @param id
   */
  void disable(String id);

  /**
   * 验证重复-工具方法
   *
   * @param repeatModelDto
   */
  void validateRepeat(ScanActivityCheckRepeatModelDto repeatModelDto);
}
