package com.biz.crm.cps.business.activity.scan.local.service;

import com.biz.crm.cps.business.activity.scan.local.entity.ScanActivityUserArea;
import java.util.List;
import java.util.Set;

/**
 * 消费者扫码活动区域配置接口
 *
 * @author sunx
 * @date 2022/3/7
 */
public interface ScanActivityUserAreaService {

  /**
   * 保存消费者扫码区域配置
   *
   * @param areaList
   * @param actCode
   */
  void createArea(List<ScanActivityUserArea> areaList, String actCode);

  /**
   * 根据活动编码获取配置的扫码区域配置信息
   *
   * @param actCode
   * @return
   */
  List<ScanActivityUserArea> findByActCode(String actCode);

  /**
   * 省市匹配的活动编码
   *
   * @param provinceName
   * @param cityName
   * @param actCodeSet
   * @return
   */
  Set<String> findAreaActCodeSetByAreaAndActCodeIn(
      String provinceName, String cityName, Set<String> actCodeSet);
}
