package com.biz.crm.cps.business.activity.scan.local.service;

import com.biz.crm.cps.business.activity.scan.local.entity.ScanActivityUserScopeItem;
import java.util.List;
import java.util.Set;

/**
 * 扫码活动人员关联关系信息(ScanActivityUserScopeItem)表服务接口
 *
 * @author sunx
 * @date 2022-02-16 16:39:13
 */
public interface ScanActivityUserScopeItemService {

  /**
   * 根据活动编码删除关联数据
   *
   * @param actCode
   */
  void deleteByActCode(String actCode);

  /**
   * 保存参与范围关联活动信息
   *
   * @param list
   * @param actCode
   */
  void createScopeItem(List<ScanActivityUserScopeItem> list, String actCode);

  /**
   * 根据既有活动编码集合获取包含对应参与者的集合的活动编码数据
   *
   * @param participateObj
   * @param actCodeSet
   * @param userCodeSet
   * @return
   */
  Set<String> findUserScopeItemActCodeSet(
      String participateObj, Set<String> actCodeSet, Set<String> userCodeSet);

  /**
   * 根据参与类型+参与对象编码获取已参与且正在执行的活动编码集合
   *
   * @param participateObj
   * @param userCode
   * @return
   */
  Set<String> findCurExecActCodeSetByParticipateObjAndUserCode(String participateObj, String userCode);
}
