package com.biz.crm.cps.business.activity.scan.local.service.internal;

import com.biz.crm.cps.business.activity.scan.local.entity.ScanActivityParticipateScope;
import com.biz.crm.cps.business.activity.scan.local.repository.ScanActivityParticipateScopeRepository;
import com.biz.crm.cps.business.activity.scan.local.service.ScanActivityParticipateScopeService;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.List;
import java.util.Set;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

/**
 * @author sunx
 * @date 2022/2/22
 */
@Slf4j
@Service("scanActivityParticipateScopeService")
public class ScanActivityParticipateScopeServiceImpl
    implements ScanActivityParticipateScopeService {

  @Autowired private ScanActivityParticipateScopeRepository scanActivityParticipateScopeRepository;

  @Override
  @Transactional
  public void createParticipateScope(String actCode, List<ScanActivityParticipateScope> list) {
    Validate.notBlank(actCode, "扫码活动编码不能为空");
    this.scanActivityParticipateScopeRepository.deleteByActCode(actCode);
    if (CollectionUtils.isEmpty(list)) {
      return;
    }
    int i = 0;
    Set<String> set1 = Sets.newHashSet();
    for (ScanActivityParticipateScope item : list) {
      item.setActCode(actCode);
      item.setId(StringUtils.EMPTY);
      item.setSort(i++);
      Validate.notBlank(item.getParticipateScopeType(), "参与范围类型不能为空");
      Validate.notBlank(item.getRelateCode(), "关联业务编码不能为空");
      Validate.isTrue(
          set1.add(StringUtils.join(item.getParticipateScopeType(), "-", item.getRelateCode())),
          "存在重复的范围配置数据");
    }
    this.scanActivityParticipateScopeRepository.saveBatch(list);
  }

  @Override
  public List<ScanActivityParticipateScope> findByActCode(String actCode) {
    if (StringUtils.isBlank(actCode)) {
      return Lists.newLinkedList();
    }
    return this.scanActivityParticipateScopeRepository.findByActCodes(Sets.newHashSet(actCode));
  }
}
