package com.biz.crm.cps.business.activity.scan.local.service.internal;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.cps.business.activity.scan.local.entity.ScanActivityProductScopeItem;
import com.biz.crm.cps.business.activity.scan.local.repository.ScanActivityProductScopeItemRepository;
import com.biz.crm.cps.business.activity.scan.sdk.dto.ScanActivityProductScopeItemPaginationDto;
import com.biz.crm.cps.business.activity.scan.sdk.service.ScanActivityProductScopeItemVoService;
import com.biz.crm.cps.business.activity.scan.sdk.vo.ScanActivityProductScopeItemVo;
import com.biz.crm.mdm.business.material.sdk.service.MaterialVoService;
import com.biz.crm.mdm.business.material.sdk.vo.MaterialVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

/**
 * 参与物料明细vo接口实现
 *
 * @author sunx
 * @date 2022/2/23
 */
@Slf4j
@Service
public class ScanActivityProductScopeItemVoServiceImpl
    implements ScanActivityProductScopeItemVoService {

  @Autowired private ScanActivityProductScopeItemRepository scanActivityProductScopeItemRepository;

  @Autowired private MaterialVoService materialVoService;

  @Autowired
  @Qualifier("nebulaToolkitService")
  private NebulaToolkitService nebulaToolkitService;

  @Override
  public Page<ScanActivityProductScopeItemVo> findByConditions(
      ScanActivityProductScopeItemPaginationDto dto) {
    if (Objects.isNull(dto)) {
      return null;
    }
    dto.setPage(Optional.ofNullable(dto.getPage()).orElse(0));
    dto.setSize(Optional.ofNullable(dto.getSize()).orElse(50));
    if (StringUtils.isBlank(dto.getActCode())) {
      return null;
    }
    Page<ScanActivityProductScopeItem> page = new Page<>(dto.getPage(), dto.getSize());
    Page<ScanActivityProductScopeItem> pageResult =
        this.scanActivityProductScopeItemRepository.findByConditions(page, dto);
    if (Objects.isNull(pageResult) || CollectionUtils.isEmpty(pageResult.getRecords())) {
      return null;
    }

    Set<String> materialCodeSet =
        pageResult.getRecords().stream()
            .filter(a -> StringUtils.isNotBlank(a.getMaterialCode()))
            .map(ScanActivityProductScopeItem::getMaterialCode)
            .collect(Collectors.toSet());
    // k-物料编码,v-物料信息
    Map<String, MaterialVo> map = Maps.newHashMap();
    if (!CollectionUtils.isEmpty(materialCodeSet)) {
      // 获取物料明细信息
      List<MaterialVo> materialVoList =
          this.materialVoService.findDetailByMaterialCodes(materialCodeSet);
      if (!CollectionUtils.isEmpty(materialVoList)) {
        map =
            materialVoList.stream()
                .filter(a -> StringUtils.isNotBlank(a.getMaterialCode()))
                .collect(
                    Collectors.toMap(
                        MaterialVo::getMaterialCode, Function.identity(), (a, b) -> a));
      }
    }
    List<ScanActivityProductScopeItemVo> list = Lists.newLinkedList();
    for (ScanActivityProductScopeItem item : pageResult.getRecords()) {
      ScanActivityProductScopeItemVo cur = new ScanActivityProductScopeItemVo();
      MaterialVo vo = map.get(item.getMaterialCode());
      if (Objects.nonNull(vo)) {
        cur =
            this.nebulaToolkitService.copyObjectByBlankList(
                vo, ScanActivityProductScopeItemVo.class, HashSet.class, ArrayList.class);
      }
      cur.setMaterialCode(item.getMaterialCode());
      list.add(cur);
    }
    Page<ScanActivityProductScopeItemVo> re = new Page<>();
    re.setTotal(pageResult.getTotal());
    re.setSize(pageResult.getSize());
    re.setRecords(list);
    return re;
  }
}
