package com.biz.crm.cps.business.activity.scan.local.service.internal;

import com.biz.crm.cps.business.activity.scan.local.entity.ScanActivityProductScope;
import com.biz.crm.cps.business.activity.scan.local.repository.ScanActivityProductScopeRepository;
import com.biz.crm.cps.business.activity.scan.local.service.ScanActivityProductScopeService;
import com.google.common.collect.Lists;
import java.util.List;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

/**
 * 扫码活动物料范围配置信息(ScanActivityProductScope)表服务实现类
 *
 * @author sunx
 * @date 2022-02-16 16:39:04
 */
@Slf4j
@Service("scanActivityProductScopeService")
public class ScanActivityProductScopeServiceImpl implements ScanActivityProductScopeService {

  @Autowired private ScanActivityProductScopeRepository scanActivityProductScopeRepository;

  @Override
  public List<ScanActivityProductScope> findByActCode(String actCode) {
    if (StringUtils.isBlank(actCode)) {
      return Lists.newLinkedList();
    }
    return this.scanActivityProductScopeRepository.findByActCode(actCode);
  }

  @Override
  @Transactional
  public void createProductScope(List<ScanActivityProductScope> list, String actCode) {
    Validate.notBlank(actCode, "活动编码不能为空");
    Validate.isTrue(!CollectionUtils.isEmpty(list), "活动物料配置信息不能为空");
    this.scanActivityProductScopeRepository.deleteByActCode(actCode);
    int i = 0;
    for (ScanActivityProductScope item : list) {
      item.setActCode(actCode);
      item.setId(StringUtils.EMPTY);
      item.setSort(i++);
    }
    this.scanActivityProductScopeRepository.saveBatch(list);
  }
}
