package com.biz.crm.cps.business.activity.scan.local.service.internal;

import com.biz.crm.cps.business.activity.scan.local.entity.ScanActivityUserArea;
import com.biz.crm.cps.business.activity.scan.local.repository.ScanActivityUserAreaRepository;
import com.biz.crm.cps.business.activity.scan.local.service.ScanActivityUserAreaService;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

/**
 * 消费者扫码活动区域配置接口实现
 *
 * @author sunx
 * @date 2022/3/7
 */
@Slf4j
@Service
public class ScanActivityUserAreaServiceImpl implements ScanActivityUserAreaService {

  @Autowired private ScanActivityUserAreaRepository scanActivityUserAreaRepository;

  @Override
  @Transactional
  public void createArea(List<ScanActivityUserArea> areaList, String actCode) {
    Validate.notBlank(actCode, "扫码活动编码不能为空");
    this.scanActivityUserAreaRepository.deleteByActCode(actCode);
    if (CollectionUtils.isEmpty(areaList)) {
      return;
    }
    int i = 0;
    for (ScanActivityUserArea item : areaList) {
      item.setActCode(actCode);
      item.setSort(i++);
    }
    this.scanActivityUserAreaRepository.saveBatch(areaList);
  }

  @Override
  public List<ScanActivityUserArea> findByActCode(String actCode) {
    if (StringUtils.isBlank(actCode)) {
      return Lists.newLinkedList();
    }
    return this.scanActivityUserAreaRepository.findByActCode(actCode);
  }

  @Override
  public Set<String> findAreaActCodeSetByAreaAndActCodeIn(
      String provinceName, String cityName, Set<String> actCodeSet) {
    if (CollectionUtils.isEmpty(actCodeSet)) {
      return Sets.newHashSet();
    }
    provinceName = Optional.ofNullable(provinceName).orElse(StringUtils.EMPTY);
    cityName = Optional.ofNullable(cityName).orElse(StringUtils.EMPTY);

    return this.scanActivityUserAreaRepository.findAreaActCodeSetByAreaAndActCodeIn(
        provinceName, cityName, actCodeSet);
  }
}
