package com.biz.crm.cps.business.activity.scan.local.service.internal;

import com.biz.crm.cps.business.activity.scan.local.entity.ScanActivityUserScopeItem;
import com.biz.crm.cps.business.activity.scan.local.repository.ScanActivityUserScopeItemRepository;
import com.biz.crm.cps.business.activity.scan.local.service.ScanActivityUserScopeItemService;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.Date;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

/**
 * 扫码活动人员关联关系信息(ScanActivityUserScopeItem)表服务实现类
 *
 * @author sunx
 * @date 2022-02-16 16:39:13
 */
@Slf4j
@Service("scanActivityUserScopeItemService")
public class ScanActivityUserScopeItemServiceImpl implements ScanActivityUserScopeItemService {

  @Autowired private ScanActivityUserScopeItemRepository scanActivityUserScopeItemRepository;

  @Autowired
  @Qualifier("nebulaToolkitService")
  private NebulaToolkitService nebulaToolkitService;

  @Override
  @Transactional
  public void deleteByActCode(String actCode) {
    Validate.notBlank(actCode, "扫码活动编码不能为空");
    this.scanActivityUserScopeItemRepository.deleteByActCode(actCode);
  }

  @Override
  @Transactional
  public void createScopeItem(List<ScanActivityUserScopeItem> list, String actCode) {
    Validate.notBlank(actCode, "扫码活动编码不能为空");
    if (CollectionUtils.isEmpty(list)) {
      this.scanActivityUserScopeItemRepository.deleteByActCode(actCode);
      return;
    }
    ScanActivityUserScopeItem first = list.get(0);
    String participateObj = first.getParticipateObj();
    Boolean joinFlag = first.getJoinFlag();
    Date createTime = first.getCreateTime();

    Set<String> curUserCodeSet =
        list.stream().map(ScanActivityUserScopeItem::getUserCode).collect(Collectors.toSet());
    List<ScanActivityUserScopeItem> oldList =
        this.scanActivityUserScopeItemRepository.findByActCodes(Sets.newHashSet(actCode));
    Set<String> oldUserCodeSet = Sets.newHashSet();
    if (!CollectionUtils.isEmpty(oldList)) {
      oldUserCodeSet =
          oldList.stream().map(ScanActivityUserScopeItem::getUserCode).collect(Collectors.toSet());
    }
    Set<String> delUserCodeSet = Sets.newHashSet();
    Set<String> addUserCodeSet = Sets.newHashSet();

    if (!CollectionUtils.isEmpty(curUserCodeSet)) {
      delUserCodeSet = Sets.difference(oldUserCodeSet, curUserCodeSet);
      addUserCodeSet = Sets.difference(curUserCodeSet, oldUserCodeSet);
    }

    if (!CollectionUtils.isEmpty(delUserCodeSet)) {
      Set<String> finalDelUserCodeSet = delUserCodeSet;
      Set<String> ids =
          oldList.stream()
              .filter(a -> finalDelUserCodeSet.contains(a.getUserCode()))
              .map(ScanActivityUserScopeItem::getId)
              .collect(Collectors.toSet());
      if (!CollectionUtils.isEmpty(ids)) {
        this.scanActivityUserScopeItemRepository.removeByIds(ids);
      }
    }
    if (!CollectionUtils.isEmpty(addUserCodeSet)) {
      List<ScanActivityUserScopeItem> addList = Lists.newLinkedList();
      for (String item : addUserCodeSet) {
        ScanActivityUserScopeItem cur = new ScanActivityUserScopeItem();
        cur.setActCode(actCode);
        cur.setUserCode(item);
        cur.setParticipateObj(participateObj);
        cur.setJoinFlag(joinFlag);
        cur.setCreateTime(createTime);
        addList.add(cur);
      }
      this.scanActivityUserScopeItemRepository.saveBatch(addList);
    }
  }

  @Override
  public Set<String> findUserScopeItemActCodeSet(
      String participateObj, Set<String> actCodeSet, Set<String> userCodeSet) {
    if (StringUtils.isBlank(participateObj)
        || CollectionUtils.isEmpty(actCodeSet)
        || CollectionUtils.isEmpty(userCodeSet)) {
      return Sets.newHashSet();
    }
    Set<String> set = Sets.newHashSet();
    for (List<String> list : Lists.partition(Lists.newArrayList(userCodeSet), 500)) {
      Set<String> cur =
          this.scanActivityUserScopeItemRepository.findUserScopeItemActCodeSet(
              participateObj, actCodeSet, Sets.newHashSet(list));
      if (CollectionUtils.isEmpty(cur)) {
        continue;
      }
      set.addAll(cur);
    }
    return set;
  }

  @Override
  public Set<String> findCurExecActCodeSetByParticipateObjAndUserCode(
      String participateObj, String userCode) {
    if (StringUtils.isAnyBlank(participateObj, userCode)) {
      return Sets.newHashSet();
    }
    return this.scanActivityUserScopeItemRepository
        .findCurExecActCodeSetByParticipateObjAndUserCode(participateObj, userCode);
  }
}
