package com.biz.crm.cps.business.activity.scan.local.service.internal;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.cps.business.activity.scan.local.entity.ScanActivityUserScopeItem;
import com.biz.crm.cps.business.activity.scan.local.repository.ScanActivityUserScopeItemRepository;
import com.biz.crm.cps.business.activity.scan.sdk.dto.ScanActivityUserScopeItemPaginationDto;
import com.biz.crm.cps.business.activity.scan.sdk.service.ScanActivityParticipateScopeVoService;
import com.biz.crm.cps.business.activity.scan.sdk.service.ScanActivityUserScopeItemVoService;
import com.biz.crm.cps.business.activity.scan.sdk.vo.ScanActivityUserScopeItemVo;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

/**
 * 可参与人员明细vo接口实现
 *
 * @author sunx
 * @date 2022/2/24
 */
@Slf4j
@Service
public class ScanActivityUserScopeItemVoServiceImpl implements ScanActivityUserScopeItemVoService {

  @Autowired private ScanActivityUserScopeItemRepository scanActivityUserScopeItemRepository;

  @Autowired private ScanActivityParticipateScopeVoService scanActivityParticipateScopeVoService;

  @Override
  public Page<ScanActivityUserScopeItemVo> findByConditions(
      ScanActivityUserScopeItemPaginationDto dto) {
    if (Objects.isNull(dto)) {
      return null;
    }
    dto.setPage(Optional.ofNullable(dto.getPage()).orElse(0));
    dto.setSize(Optional.ofNullable(dto.getSize()).orElse(50));
    if (StringUtils.isBlank(dto.getActCode()) || StringUtils.isBlank(dto.getParticipateObj())) {
      return null;
    }
    Page<ScanActivityUserScopeItem> page = new Page<>(dto.getPage(), dto.getSize());
    Page<ScanActivityUserScopeItem> pageResult =
        this.scanActivityUserScopeItemRepository.findByConditions(page, dto);
    if (Objects.isNull(pageResult) || CollectionUtils.isEmpty(pageResult.getRecords())) {
      return null;
    }

    Set<String> userCodeSet =
        pageResult.getRecords().stream()
            .filter(a -> StringUtils.isNotBlank(a.getUserCode()))
            .map(ScanActivityUserScopeItem::getUserCode)
            .collect(Collectors.toSet());

    // k-人员编码,v-人员详情
    Map<String, JSONObject> map = Maps.newHashMap();
    if (!CollectionUtils.isEmpty(userCodeSet)) {
      map =
          this.scanActivityParticipateScopeVoService.findDataMapByParticipateObjAndUserCodes(
              dto.getParticipateObj(), userCodeSet);
    }

    List<ScanActivityUserScopeItemVo> list = Lists.newLinkedList();
    for (ScanActivityUserScopeItem item : pageResult.getRecords()) {
      ScanActivityUserScopeItemVo cur = new ScanActivityUserScopeItemVo();
      cur.setData(map.get(item.getUserCode()));
      list.add(cur);
    }
    Page<ScanActivityUserScopeItemVo> re = new Page<>();
    re.setTotal(pageResult.getTotal());
    re.setSize(pageResult.getSize());
    re.setRecords(list);
    return re;
  }
}
