package com.biz.crm.cps.business.activity.scan.local.service.notifier;

import com.biz.crm.cps.business.activity.scan.sdk.enums.ScanActivityParticipateObjEnum;
import com.biz.crm.cps.business.activity.scan.sdk.enums.ScanActivityRewardScanTypeEnum;
import com.biz.crm.cps.business.activity.scan.sdk.service.ScanActivityRewardVoService;
import com.biz.crm.cps.business.activity.scan.sdk.service.ScanActivityVoService;
import com.biz.crm.cps.business.activity.scan.sdk.service.observer.ScanActivityRewardObserver;
import com.biz.crm.cps.business.activity.scan.sdk.vo.ScanActivityRewardObserverVo;
import com.biz.crm.cps.business.activity.scan.sdk.vo.ScanActivityRewardVo;
import com.biz.crm.cps.business.activity.scan.sdk.vo.ScanActivityVo;
import com.biz.crm.cps.external.barcode.sdk.dto.ScanCodeRecordEventDto;
import com.biz.crm.cps.external.barcode.sdk.event.ScanCodeRecordEventListener;
import com.google.common.collect.Sets;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

/**
 * 扫码活动处理
 *
 * @author sunx
 * @date 2022/3/11
 */
@Component
public class ScanActivityScanCodeRecordEventListenerImpl implements ScanCodeRecordEventListener {

  @Autowired private ScanActivityRewardVoService scanActivityRewardVoService;

  @Autowired private ScanActivityVoService scanActivityVoService;

  @Autowired(required = false)
  private List<ScanActivityRewardObserver> observers;

  /**
   * 1、根据入参的扫码活动编码获取获取奖励配置信息
   *
   * <p>2、组装返利入参信息
   *
   * <p>3、通知奖励发放实现
   *
   * @param dto
   */
  @Override
  @Transactional
  public void onSuccessScan(ScanCodeRecordEventDto dto) {
    if (StringUtils.isBlank(dto.getScanActCode())) {
      return;
    }
    List<ScanActivityVo> activityVoList =
        this.scanActivityVoService.findMainByActCodes(Sets.newHashSet(dto.getScanActCode()));
    Validate.isTrue(
        !CollectionUtils.isEmpty(activityVoList),
        StringUtils.join(dto.getScanActCode(), "扫码活动不存在"));
    ScanActivityVo scanActivityVo = activityVoList.get(0);
    dto.setAccountCode(scanActivityVo.getAccountCode());
    List<ScanActivityRewardVo> rewardVoList =
        this.scanActivityRewardVoService.findByActCode(dto.getScanActCode());
    if (CollectionUtils.isEmpty(rewardVoList)) {
      return;
    }
    List<ScanActivityRewardObserverVo> data =
        this.findScanActivityRewardObserverVos(dto, rewardVoList);
    if (CollectionUtils.isEmpty(data)) {
      return;
    }
    for (ScanActivityRewardObserver observer : observers) {
      observer.createRewardRecord(data);
    }
  }

  @Override
  public void onFailScan(ScanCodeRecordEventDto dto) {
    // 当前模块暂时不需要处理此事件
  }

  /**
   * 构建奖励发放通知数据
   *
   * @param dto
   * @param rewardVoList
   * @return
   */
  private List<ScanActivityRewardObserverVo> findScanActivityRewardObserverVos(
      ScanCodeRecordEventDto dto, List<ScanActivityRewardVo> rewardVoList) {
    String barCode = dto.getBarCode();
    ScanActivityRewardScanTypeEnum rewardScanTypeEnum =
        ScanActivityRewardScanTypeEnum.findByTransformKey(dto.getBarCodeType());
    String materialCode = dto.getProductCode();
    String userCode = dto.getScanParticipatorCode();
    ScanActivityParticipateObjEnum participateObjEnum =
        ScanActivityParticipateObjEnum.findByTransformKey(dto.getParticipatorType());
    return this.scanActivityRewardVoService.findScanActivityRewardObserverVos(dto, rewardVoList);
  }
}
