package com.biz.crm.cps.business.activity.scan.local.service.register.product;

import com.biz.crm.cps.business.activity.scan.sdk.enums.ScanActivityProductScopeTypeEnum;
import com.biz.crm.cps.business.activity.scan.sdk.register.ScanActivityProductScopeRegister;
import com.google.common.collect.Sets;
import java.util.Set;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

/**
 * 物料范围注册器接口-物料组实现
 *
 * @author sunx
 * @date 2022/2/22
 */
@Component
@Slf4j
public class ScanActivityProductScopeByMaterialGroupRegisterImpl
    implements ScanActivityProductScopeRegister {

  @Override
  public String getType() {
    return ScanActivityProductScopeTypeEnum.MATERIAL_GROUP.getDictCode();
  }

  @Override
  public String getTypeDesc() {
    return ScanActivityProductScopeTypeEnum.MATERIAL_GROUP.getValue();
  }

  @Override
  public int sort() {
    return 1;
  }

  @Override
  public Set<String> findByRelateCodeSet(Set<String> relateCodeSet) {
    if (CollectionUtils.isEmpty(relateCodeSet)) {
      return Sets.newHashSet();
    }
    // TODO 物料组获取物料编码信息逻辑待实现
    return relateCodeSet;
  }
}
