package com.biz.crm.cps.business.activity.scan.local.service.register.product;

import com.biz.crm.cps.business.activity.scan.sdk.enums.ScanActivityProductScopeTypeEnum;
import com.biz.crm.cps.business.activity.scan.sdk.register.ScanActivityProductScopeRegister;
import com.biz.crm.mdm.business.material.sdk.service.MaterialVoService;
import com.google.common.collect.Sets;
import java.util.Set;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

/**
 * 物料范围注册器接口-产品层级实现
 *
 * @author sunx
 * @date 2022/2/22
 */
@Component
@Slf4j
public class ScanActivityProductScopeByProductLevelRegisterImpl
    implements ScanActivityProductScopeRegister {

  @Autowired private MaterialVoService materialVoService;

  @Override
  public String getType() {
    return ScanActivityProductScopeTypeEnum.PRODUCT_LEVEL.getDictCode();
  }

  @Override
  public String getTypeDesc() {
    return ScanActivityProductScopeTypeEnum.PRODUCT_LEVEL.getValue();
  }

  @Override
  public int sort() {
    return 1;
  }

  @Override
  public Set<String> findByRelateCodeSet(Set<String> relateCodeSet) {
    if (CollectionUtils.isEmpty(relateCodeSet)) {
      return Sets.newHashSet();
    }
    // 根据产品层级获取对应层级及子级管理的物料编码集合
    return this.materialVoService.findCodeByProductLevelCodes(relateCodeSet);
  }
}
