package com.biz.crm.cps.business.activity.scan.local.service.register.reward;

import com.biz.crm.business.common.sdk.model.LoginUserDetailsForCPS;
import com.biz.crm.business.common.sdk.service.LoginUserService;
import com.biz.crm.cps.business.activity.scan.sdk.enums.ScanActivityParticipateObjEnum;
import com.biz.crm.cps.business.activity.scan.sdk.enums.ScanActivityRewardScanTypeEnum;
import com.biz.crm.cps.business.activity.scan.sdk.enums.ScanActivityRewardTypeEnum;
import com.biz.crm.cps.business.activity.scan.sdk.register.ScanActivityRewardRegister;
import com.biz.crm.cps.business.activity.scan.sdk.vo.RewardValueVo;
import com.biz.crm.cps.business.activity.scan.sdk.vo.ScanActivityRewardObserverVo;
import com.biz.crm.cps.business.activity.scan.sdk.vo.ScanActivityRewardValueVo;
import com.biz.crm.cps.business.activity.scan.sdk.vo.ScanActivityRewardVo;
import com.biz.crm.cps.business.participator.sdk.service.DealerVoService;
import com.biz.crm.cps.business.participator.sdk.vo.DealerVo;
import com.biz.crm.cps.external.barcode.sdk.dto.ScanCodeRecordEventDto;
import com.google.common.collect.Lists;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

import java.util.List;
import java.util.Objects;

/**
 * 经销商奖励通知信息构建实现
 *
 * @author sunx
 * @date 2022/3/11
 */
@Component
public class CustomerScanActivityRewardRegisterImpl implements ScanActivityRewardRegister {

  @Autowired(required = false)
  private LoginUserService loginUserService;

  @Autowired private DealerVoService dealerVoService;

  @Override
  public String getKey() {
    return ScanActivityParticipateObjEnum.CUSTOMER.getDictCode();
  }

  @Override
  public List<ScanActivityRewardObserverVo> findScanActivityRewardObserverVos(
      ScanCodeRecordEventDto dto, List<ScanActivityRewardVo> rewardList) {
    List<ScanActivityRewardObserverVo> list = Lists.newLinkedList();
    ScanActivityRewardScanTypeEnum rewardScanTypeEnum =
        ScanActivityRewardScanTypeEnum.findByBarCodeType(dto.getBarCodeType());
    LoginUserDetailsForCPS loginUser = loginUserService.getLoginDetails(LoginUserDetailsForCPS.class);
    Validate.notNull(loginUser, "未获取到操作人信息");
    String consumerName = loginUser.getConsumerName();
    // 经销商编码
    String customerCode = dto.getScanParticipatorCode();
    DealerVo dealerVo = this.dealerVoService.findByCustomerCode(customerCode);
    Validate.notNull(dealerVo, "经销商信息不存在");

    for (ScanActivityRewardVo item : rewardList) {
      if (!rewardScanTypeEnum.getDictCode().equals(item.getType())) {
        continue;
      }
      ScanActivityRewardObserverVo cur = new ScanActivityRewardObserverVo();
      cur.setScanActCode(dto.getScanActCode());
      cur.setAccountCode(dto.getAccountCode());
      cur.setMaterialCode(dto.getProductCode());
      cur.setTriggerAction(StringUtils.join("扫", rewardScanTypeEnum.getValue()));
      cur.setRecordCode(dto.getRecordCode());
      ScanActivityRewardTypeEnum rewardTypeEnum =
          ScanActivityRewardTypeEnum.findByDictCode(item.getRewardType());
      if (Objects.isNull(rewardTypeEnum)) {
        continue;
      }
      cur.setRewardType(rewardTypeEnum.getTransformKey());
      cur.setParticipateObj(ScanActivityParticipateObjEnum.CUSTOMER.getTransformKey());
      cur.setUserCode(dto.getScanParticipatorCode());
      cur.setName(consumerName);
      cur.setRandomFlag(item.getRandomFlag());
      cur.setChannel(dealerVo.getChannelCode());
      cur.setOrgCode(dealerVo.getOrgCode());
      cur.setOrgName(dealerVo.getOrgName());
      cur.setValueList(this.findRewardValueList(item.getValueList()));
      list.add(cur);
    }
    return list;
  }

  /**
   * 获取奖励配置信息
   *
   * @param list
   * @return
   */
  private List<RewardValueVo> findRewardValueList(List<ScanActivityRewardValueVo> list) {
    if (CollectionUtils.isEmpty(list)) {
      return Lists.newLinkedList();
    }
    List<RewardValueVo> re = Lists.newArrayList();
    for (ScanActivityRewardValueVo item : list) {
      RewardValueVo cur = new RewardValueVo();
      cur.setPercent(item.getRate());
      cur.setCash(item.getRewardValue());
      re.add(cur);
    }
    return re;
  }
}
