package com.biz.crm.cps.business.activity.scan.local.service.register.reward;

import com.biz.crm.cps.business.activity.scan.sdk.enums.ScanActivityParticipateObjEnum;
import com.biz.crm.cps.business.activity.scan.sdk.register.ScanActivityRewardRegister;
import com.biz.crm.cps.business.activity.scan.sdk.vo.ScanActivityRewardObserverVo;
import com.biz.crm.cps.business.activity.scan.sdk.vo.ScanActivityRewardVo;
import com.biz.crm.cps.external.barcode.sdk.dto.ScanCodeRecordEventDto;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

/**
 * 导购奖励通知信息构建实现
 *
 * @author sunx
 * @date 2022/3/11
 */
@Component
public class ShopperScanActivityRewardRegisterImpl implements ScanActivityRewardRegister {

  @Autowired
  private UserAndShopperScanActivityRewardComponent userAndShopperScanActivityRewardComponent;

  @Override
  public String getKey() {
    return ScanActivityParticipateObjEnum.SHOPPER.getDictCode();
  }

  @Override
  public List<ScanActivityRewardObserverVo> findScanActivityRewardObserverVos(
      ScanCodeRecordEventDto dto, List<ScanActivityRewardVo> rewardList) {
    return this.userAndShopperScanActivityRewardComponent.findScanActivityRewardObserverVos(
        dto, rewardList, ScanActivityParticipateObjEnum.SHOPPER.getTransformKey());
  }
}
