package com.biz.crm.cps.business.activity.scan.local.service.register.reward;

import com.biz.crm.business.common.sdk.model.LoginUserDetailsForCPS;
import com.biz.crm.business.common.sdk.service.LoginUserService;
import com.biz.crm.cps.business.activity.scan.sdk.enums.ScanActivityParticipateObjEnum;
import com.biz.crm.cps.business.activity.scan.sdk.enums.ScanActivityRebateObjTypeEnum;
import com.biz.crm.cps.business.activity.scan.sdk.enums.ScanActivityRewardScanTypeEnum;
import com.biz.crm.cps.business.activity.scan.sdk.enums.ScanActivityRewardTypeEnum;
import com.biz.crm.cps.business.activity.scan.sdk.vo.RewardValueVo;
import com.biz.crm.cps.business.activity.scan.sdk.vo.ScanActivityRebateValueVo;
import com.biz.crm.cps.business.activity.scan.sdk.vo.ScanActivityRebateVo;
import com.biz.crm.cps.business.activity.scan.sdk.vo.ScanActivityRewardObserverVo;
import com.biz.crm.cps.business.activity.scan.sdk.vo.ScanActivityRewardValueVo;
import com.biz.crm.cps.business.activity.scan.sdk.vo.ScanActivityRewardVo;
import com.biz.crm.cps.business.participator.sdk.service.DealerVoService;
import com.biz.crm.cps.business.participator.sdk.service.TerminalVoService;
import com.biz.crm.cps.business.participator.sdk.vo.DealerVo;
import com.biz.crm.cps.business.participator.sdk.vo.TerminalVo;
import com.biz.crm.cps.external.barcode.sdk.dto.ScanBarCodeRecordFindDto;
import com.biz.crm.cps.external.barcode.sdk.dto.ScanCodeRecordEventDto;
import com.biz.crm.cps.external.barcode.sdk.service.ScanCodeRecordVoService;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;
import java.util.stream.Collectors;

/**
 * 消费者、导购扫码活动奖励通知信息component
 *
 * @author sunx
 * @date 2022/3/14
 */
@Component
public class UserAndShopperScanActivityRewardComponent {

  @Autowired private ScanCodeRecordVoService scanCodeRecordVoService;

  @Autowired(required = false)
  private LoginUserService loginUserService;

  @Autowired private DealerVoService dealerVoService;

  @Autowired private TerminalVoService terminalVoService;

  public List<ScanActivityRewardObserverVo> findScanActivityRewardObserverVos(
      ScanCodeRecordEventDto dto, List<ScanActivityRewardVo> rewardList, String participateObj) {
    List<ScanActivityRewardObserverVo> list = Lists.newLinkedList();
    ScanActivityRewardScanTypeEnum rewardScanTypeEnum =
        ScanActivityRewardScanTypeEnum.findByBarCodeType(dto.getBarCodeType());
    List<ScanActivityRewardVo> curRewardList =
        rewardList.stream()
            .filter(a -> rewardScanTypeEnum.getDictCode().equals(a.getType()))
            .collect(Collectors.toList());
    if (CollectionUtils.isEmpty(curRewardList)) {
      return list;
    }
    // 是否有经销商\终端反向分利规则配置
    Boolean findCustomerFlag = Boolean.FALSE;
    Boolean findTerminalFlag = Boolean.FALSE;
    for (ScanActivityRewardVo item : curRewardList) {
      List<ScanActivityRebateVo> rebateList = item.getRebateList();
      if (!CollectionUtils.isEmpty(rebateList)) {
        for (ScanActivityRebateVo sub : rebateList) {
          if (ScanActivityRebateObjTypeEnum.CUSTOMER.getDictCode().equals(sub.getObjType())) {
            findCustomerFlag = true;
            break;
          }
        }
        for (ScanActivityRebateVo sub : rebateList) {
          if (ScanActivityRebateObjTypeEnum.TERMINAL.getDictCode().equals(sub.getObjType())) {
            findTerminalFlag = true;
            break;
          }
        }
      }
    }
    String customerCode =
        this.findRebateBusinessCode(
            findCustomerFlag,
            dto.getBarCode(),
            rewardScanTypeEnum.getBarCodeType(),
            ScanActivityParticipateObjEnum.CUSTOMER.getTransformKey());
    String terminalCode =
        this.findRebateBusinessCode(
            findTerminalFlag,
            dto.getBarCode(),
            rewardScanTypeEnum.getBarCodeType(),
            ScanActivityParticipateObjEnum.TERMINAL.getTransformKey());

    LoginUserDetailsForCPS loginUser = loginUserService.getLoginDetails(LoginUserDetailsForCPS.class);
    Validate.notNull(loginUser, "未获取到操作人信息");
    String consumerName = loginUser.getConsumerName();

    for (ScanActivityRewardVo item : curRewardList) {
      ScanActivityRewardObserverVo cur = new ScanActivityRewardObserverVo();
      cur.setScanActCode(dto.getScanActCode());
      cur.setAccountCode(dto.getAccountCode());
      cur.setMaterialCode(dto.getProductCode());
      cur.setTriggerAction(StringUtils.join("扫", rewardScanTypeEnum.getValue()));
      cur.setRecordCode(dto.getRecordCode());
      ScanActivityRewardTypeEnum rewardTypeEnum =
          ScanActivityRewardTypeEnum.findByDictCode(item.getRewardType());
      if (Objects.isNull(rewardTypeEnum)) {
        continue;
      }
      cur.setRewardType(rewardTypeEnum.getTransformKey());
      cur.setParticipateObj(participateObj);
      cur.setUserCode(dto.getScanParticipatorCode());
      cur.setName(consumerName);
      cur.setRandomFlag(item.getRandomFlag());
      cur.setValueList(this.findRewardValueList(item.getValueList()));
      cur.setItemList(this.findRebateItem(cur, customerCode, terminalCode, item.getRebateList()));
      list.add(cur);
    }
    return list;
  }

  /**
   * 获取最近扫码的经销商编码 或终端编码
   *
   * @param flag
   * @param barCode
   * @param barCodeType
   * @param participatorType
   * @return
   */
  private String findRebateBusinessCode(
      Boolean flag, String barCode, String barCodeType, String participatorType) {
    if (!flag) {
      return StringUtils.EMPTY;
    }
    // 获取当前条码最近扫码的经销商编码
    ScanBarCodeRecordFindDto scanBarCodeRecordFindDto = new ScanBarCodeRecordFindDto();
    scanBarCodeRecordFindDto.setBarCodeSet(Sets.newHashSet(barCode));
    scanBarCodeRecordFindDto.setBarCodeType(barCodeType);
    scanBarCodeRecordFindDto.setParticipatorType(participatorType);
    return this.scanCodeRecordVoService.findLastScanUserCodeByScanBarCodeRecordFindDto(
        scanBarCodeRecordFindDto);
  }

  /**
   * 获取奖励配置信息
   *
   * @param list
   * @return
   */
  private List<RewardValueVo> findRewardValueList(List<ScanActivityRewardValueVo> list) {
    if (CollectionUtils.isEmpty(list)) {
      return Lists.newLinkedList();
    }
    List<RewardValueVo> re = Lists.newArrayList();
    for (ScanActivityRewardValueVo item : list) {
      RewardValueVo cur = new RewardValueVo();
      cur.setPercent(item.getRate());
      cur.setCash(item.getRewardValue());
      re.add(cur);
    }
    return re;
  }

  /**
   * 获取终端反向分利item数据
   *
   * @param customerCode
   * @param reward
   * @param terminalCode
   * @param rebateList
   * @return
   */
  private List<ScanActivityRewardObserverVo> findRebateItem(
      ScanActivityRewardObserverVo reward,
      String customerCode,
      String terminalCode,
      List<ScanActivityRebateVo> rebateList) {
    if (StringUtils.isAllBlank(customerCode, terminalCode) || CollectionUtils.isEmpty(rebateList)) {
      return Lists.newLinkedList();
    }
    List<ScanActivityRewardObserverVo> re = Lists.newArrayList();
    if (StringUtils.isNotBlank(customerCode)) {

      // 获取经销商名称
      DealerVo dealerVo = this.dealerVoService.findByCustomerCode(customerCode);
      Validate.notNull(dealerVo, "反向分利的经销商信息不存在");
      String customerName = dealerVo.getCustomerName();

      for (ScanActivityRebateVo item : rebateList) {
        if (!ScanActivityRebateObjTypeEnum.CUSTOMER.getDictCode().equals(item.getObjType())) {
          continue;
        }
        ScanActivityRewardObserverVo cur = new ScanActivityRewardObserverVo();
        cur.setScanActCode(reward.getScanActCode());
        cur.setAccountCode(reward.getAccountCode());
        cur.setMaterialCode(reward.getMaterialCode());
        cur.setTriggerAction(reward.getTriggerAction());
        cur.setRecordCode(reward.getRecordCode());
        ScanActivityRewardTypeEnum rewardTypeEnum =
            ScanActivityRewardTypeEnum.findByDictCode(item.getRewardType());
        if (Objects.isNull(rewardTypeEnum)) {
          continue;
        }
        cur.setRewardType(rewardTypeEnum.getTransformKey());
        cur.setParticipateObj(ScanActivityParticipateObjEnum.CUSTOMER.getTransformKey());
        cur.setUserCode(customerCode);
        cur.setName(customerName);
        cur.setRandomFlag(item.getRandomFlag());
        cur.setValueList(this.findRebateValueList(item.getValueList()));
        re.add(cur);
      }
    }
    if (StringUtils.isNotBlank(terminalCode)) {
      // 获取终端名称
      List<TerminalVo> terminalVoList =
          this.terminalVoService.findByTerminalCodes(Lists.newArrayList(terminalCode));
      Validate.isTrue(!CollectionUtils.isEmpty(terminalVoList), "反向分利的终端信息不存在");
      Optional<TerminalVo> first = terminalVoList.stream().findFirst();
      String terminalName = first.get().getTerminalName();

      for (ScanActivityRebateVo item : rebateList) {
        if (!ScanActivityRebateObjTypeEnum.TERMINAL.getDictCode().equals(item.getObjType())) {
          continue;
        }
        ScanActivityRewardObserverVo cur = new ScanActivityRewardObserverVo();
        cur.setScanActCode(reward.getScanActCode());
        cur.setAccountCode(reward.getAccountCode());
        cur.setMaterialCode(reward.getMaterialCode());
        cur.setTriggerAction(reward.getTriggerAction());
        cur.setRecordCode(reward.getRecordCode());
        ScanActivityRewardTypeEnum rewardTypeEnum =
            ScanActivityRewardTypeEnum.findByDictCode(item.getRewardType());
        if (Objects.isNull(rewardTypeEnum)) {
          continue;
        }
        cur.setRewardType(rewardTypeEnum.getTransformKey());
        cur.setParticipateObj(ScanActivityParticipateObjEnum.TERMINAL.getTransformKey());
        cur.setUserCode(terminalCode);
        cur.setName(terminalName);
        cur.setRandomFlag(item.getRandomFlag());
        cur.setValueList(this.findRebateValueList(item.getValueList()));
        re.add(cur);
      }
    }
    return re;
  }

  /**
   * 获取返利配置信息
   *
   * @param list
   * @return
   */
  private List<RewardValueVo> findRebateValueList(List<ScanActivityRebateValueVo> list) {
    if (CollectionUtils.isEmpty(list)) {
      return Lists.newLinkedList();
    }
    List<RewardValueVo> re = Lists.newArrayList();
    for (ScanActivityRebateValueVo item : list) {
      RewardValueVo cur = new RewardValueVo();
      cur.setPercent(item.getRate());
      cur.setCash(item.getRebateValue());
      re.add(cur);
    }
    return re;
  }
}
