package com.biz.crm.cps.business.activity.scan.local.service.register.reward;

import com.biz.crm.cps.business.activity.scan.sdk.enums.ScanActivityParticipateObjEnum;
import com.biz.crm.cps.business.activity.scan.sdk.register.ScanActivityRewardRegister;
import com.biz.crm.cps.business.activity.scan.sdk.vo.ScanActivityRewardObserverVo;
import com.biz.crm.cps.business.activity.scan.sdk.vo.ScanActivityRewardVo;
import com.biz.crm.cps.external.barcode.sdk.dto.ScanCodeRecordEventDto;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

/**
 * 消费者奖励通知信息构建实现
 *
 * @author sunx
 * @date 2022/3/11
 */
@Component
public class UserScanActivityRewardRegisterImpl implements ScanActivityRewardRegister {

  @Autowired
  private UserAndShopperScanActivityRewardComponent userAndShopperScanActivityRewardComponent;

  @Override
  public String getKey() {
    return ScanActivityParticipateObjEnum.USER.getDictCode();
  }

  @Override
  public List<ScanActivityRewardObserverVo> findScanActivityRewardObserverVos(
      ScanCodeRecordEventDto dto, List<ScanActivityRewardVo> rewardList) {
    return this.userAndShopperScanActivityRewardComponent.findScanActivityRewardObserverVos(
        dto, rewardList, ScanActivityParticipateObjEnum.USER.getTransformKey());
  }
}
