package com.biz.crm.cps.business.activity.scan.local.service.register.user;

import com.alibaba.fastjson.JSONObject;
import com.biz.crm.cps.business.activity.scan.sdk.dto.ScanActivityParticipateScopeDto;
import com.biz.crm.cps.business.activity.scan.sdk.enums.ScanActivityParticipateScopeTypeEnum;
import com.biz.crm.cps.business.activity.scan.sdk.enums.ScanActivityScopeEnum;
import com.biz.crm.cps.business.activity.scan.sdk.register.ScanActivityParticipateScopeRegister;
import com.biz.crm.cps.business.participator.sdk.service.DealerVoService;
import com.biz.crm.cps.business.participator.sdk.vo.DealerVo;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

/**
 * 参与对象为经销商的范围注册器实现
 *
 * @author sunx
 * @date 2022/2/25
 */
@Component
public class ScanActivityParticipateScopeByCustomerRegisterImpl
    implements ScanActivityParticipateScopeRegister {

  @Autowired private DealerVoService dealerVoService;

  @Override
  public String getType() {
    return "customer";
  }

  @Override
  public String getTypeDesc() {
    return "经销商";
  }

  @Override
  public int sort() {
    return 1;
  }

  @Override
  public Set<String> findScopeCodeSet(
      String participateScope, List<ScanActivityParticipateScopeDto> list) {
    if (StringUtils.isBlank(participateScope) || CollectionUtils.isEmpty(list)) {
      return Sets.newHashSet();
    }
    Set<String> relateCodeSet =
        list.stream()
            .filter(a -> StringUtils.isNotBlank(a.getRelateCode()))
            .map(ScanActivityParticipateScopeDto::getRelateCode)
            .collect(Collectors.toSet());
    if (ScanActivityScopeEnum.ALL.getDictCode().equals(participateScope)) {
      return Sets.newHashSet();
    }
    if (ScanActivityScopeEnum.SPECIAL.getDictCode().equals(participateScope)) {
      return relateCodeSet;
    }
    Map<String, Set<String>> map =
        list.stream()
            .filter(
                a ->
                    StringUtils.isNotBlank(a.getRelateCode())
                        && StringUtils.isNotBlank(a.getParticipateScopeType()))
            .collect(
                Collectors.groupingBy(
                    ScanActivityParticipateScopeDto::getParticipateScopeType,
                    Collectors.mapping(
                        ScanActivityParticipateScopeDto::getRelateCode, Collectors.toSet())));
    if (map.isEmpty()) {
      return Sets.newHashSet();
    }
    // 根据组织、渠道、标签获取经销商编码集合
    List<String> orgCodeList =
        Lists.newArrayList(
            map.getOrDefault(
                ScanActivityParticipateScopeTypeEnum.ORG.getDictCode(), Sets.newHashSet()));
    List<String> channelList =
        Lists.newArrayList(
            map.getOrDefault(
                ScanActivityParticipateScopeTypeEnum.CHANNEL.getDictCode(), Sets.newHashSet()));
    List<String> tagList =
        Lists.newArrayList(
            map.getOrDefault(
                ScanActivityParticipateScopeTypeEnum.TAG.getDictCode(), Sets.newHashSet()));
    return this.dealerVoService.findCustomerCodesByOrgCodesAndChannelsAndTags(
        orgCodeList, channelList, tagList);
  }

  @Override
  public Map<String, JSONObject> findDataMapByCodes(Set<String> userCodeSet) {
    if (CollectionUtils.isEmpty(userCodeSet)) {
      return Maps.newHashMap();
    }
    List<DealerVo> voList =
        this.dealerVoService.findByCustomerCodes(Lists.newArrayList(userCodeSet));
    if (CollectionUtils.isEmpty(voList)) {
      return Maps.newHashMap();
    }
    Map<String, JSONObject> map = Maps.newHashMap();
    for (DealerVo item : voList) {
      item.setOrgNameStr(item.getOrgName());
      map.put(item.getCustomerCode(), (JSONObject) JSONObject.toJSON(item));
    }
    return map;
  }
}
