package com.biz.crm.cps.business.activity.scan.local.service.register.user;

import com.alibaba.fastjson.JSONObject;
import com.biz.crm.cps.business.activity.scan.sdk.dto.ScanActivityParticipateScopeDto;
import com.biz.crm.cps.business.activity.scan.sdk.enums.ScanActivityParticipateScopeTypeEnum;
import com.biz.crm.cps.business.activity.scan.sdk.enums.ScanActivityScopeEnum;
import com.biz.crm.cps.business.activity.scan.sdk.register.ScanActivityParticipateScopeRegister;
import com.biz.crm.mdm.business.user.sdk.enums.UserTypeEnum;
import com.biz.crm.mdm.business.user.sdk.service.UserFeignVoService;
import com.biz.crm.mdm.business.user.sdk.service.UserVoService;
import com.biz.crm.mdm.business.user.sdk.vo.UserVo;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

/**
 * 参与对象为导购的范围注册器实现
 *
 * @author sunx
 * @date 2022/2/25
 */
@Component
public class ScanActivityParticipateScopeByShopperRegisterImpl
    implements ScanActivityParticipateScopeRegister {

  @Autowired private UserVoService userVoService;

  @Autowired
  private UserFeignVoService userFeignVoService;

  @Override
  public String getType() {
    return "shopper";
  }

  @Override
  public String getTypeDesc() {
    return "导购";
  }

  @Override
  public int sort() {
    return 3;
  }

  @Override
  public Set<String> findScopeCodeSet(
      String participateScope, List<ScanActivityParticipateScopeDto> list) {
    if (StringUtils.isBlank(participateScope) || CollectionUtils.isEmpty(list)) {
      return Sets.newHashSet();
    }
    Set<String> relateCodeSet =
        list.stream()
            .filter(a -> StringUtils.isNotBlank(a.getRelateCode()))
            .map(ScanActivityParticipateScopeDto::getRelateCode)
            .collect(Collectors.toSet());
    if (ScanActivityScopeEnum.ALL.getDictCode().equals(participateScope)) {
      return Sets.newHashSet();
    }
    if (ScanActivityScopeEnum.SPECIAL.getDictCode().equals(participateScope)) {
      return relateCodeSet;
    }
    Map<String, Set<String>> map =
        list.stream()
            .filter(
                a ->
                    StringUtils.isNotBlank(a.getRelateCode())
                        && StringUtils.isNotBlank(a.getParticipateScopeType()))
            .collect(
                Collectors.groupingBy(
                    ScanActivityParticipateScopeDto::getParticipateScopeType,
                    Collectors.mapping(
                        ScanActivityParticipateScopeDto::getRelateCode, Collectors.toSet())));
    if (map.isEmpty()) {
      return Sets.newHashSet();
    }
    // 根据组织、职位级别获取导购编码集合
    List<String> orgCodeList =
        Lists.newArrayList(
            map.getOrDefault(
                ScanActivityParticipateScopeTypeEnum.ORG.getDictCode(), Sets.newHashSet()));
    List<String> positionList =
        Lists.newArrayList(
            map.getOrDefault(
                ScanActivityParticipateScopeTypeEnum.POSITION.getDictCode(), Sets.newHashSet()));
    return this.userVoService.findUserNamesByCodesAndUserType(
        orgCodeList, positionList, UserTypeEnum.USER_GUIDE.getCode());
  }

  @Override
  public Map<String, JSONObject> findDataMapByCodes(Set<String> userCodeSet) {
    if (CollectionUtils.isEmpty(userCodeSet)) {
      return Maps.newHashMap();
    }
    // 获取导购信息
    List<UserVo> voList = this.userFeignVoService.findByUserNames(new ArrayList<>(userCodeSet));
    if (CollectionUtils.isEmpty(voList)) {
      return Maps.newHashMap();
    }
    Map<String, JSONObject> map = Maps.newHashMap();
    for (UserVo item : voList) {
      map.put(item.getUserName(), (JSONObject) JSONObject.toJSON(item));
    }
    return map;
  }
}
