package com.biz.crm.cps.business.activity.scan.local.service.register.user;

import com.alibaba.fastjson.JSONObject;
import com.biz.crm.cps.business.activity.scan.sdk.dto.ScanActivityParticipateScopeDto;
import com.biz.crm.cps.business.activity.scan.sdk.register.ScanActivityParticipateScopeRegister;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.springframework.stereotype.Component;

/**
 * 参与对象为消费者的范围注册器实现
 *
 * @author sunx
 * @date 2022/2/25
 */
@Component
public class ScanActivityParticipateScopeByUserRegisterImpl
    implements ScanActivityParticipateScopeRegister {

  @Override
  public String getType() {
    return "user";
  }

  @Override
  public String getTypeDesc() {
    return "消费者";
  }

  @Override
  public int sort() {
    return 4;
  }

  @Override
  public Set<String> findScopeCodeSet(
      String participateScope, List<ScanActivityParticipateScopeDto> list) {
    return Sets.newHashSet();
  }

  @Override
  public Map<String, JSONObject> findDataMapByCodes(Set<String> userCodeSet) {
    return Maps.newHashMap();
  }
}
