package com.biz.crm.cps.business.activity.scan.sdk.dto;

import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Date;
import java.util.List;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

/**
 * 扫码活动dto
 *
 * @author sunx
 * @date 2022-02-16 16:40:07
 */
@Data
@ApiModel(value = "ScanActivityDto", description = "扫码活动dto")
public class ScanActivityDto {
  /** 主键 */
  @ApiModelProperty("主键")
  private String id;

  /** 活动编码 */
  @ApiModelProperty("活动编码")
  private String code;

  /** 活动名称 */
  @ApiModelProperty("活动名称")
  private String name;

  /** 活动开始时间 */
  @ApiModelProperty("活动开始时间")
  @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
  @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private Date startTime;

  /** 活动结束时间 */
  @ApiModelProperty("活动结束时间")
  @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
  @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private Date endTime;

  /** 参与对象 ScanActivityParticipateObjEnum */
  @ApiModelProperty("参与对象,customer-经销商,terminal-终端")
  private String participateObj;

  /** 参与类型 ScanActivityParticipateTypeEnum */
  @ApiModelProperty("参与类型,manual-手动参与,automatic-自动参与")
  private String participateType;

  /** 参与开始时间 */
  @ApiModelProperty("参与开始时间")
  @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
  @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private Date participateStartTime;

  /** 参与截止时间 */
  @ApiModelProperty("参与截止时间")
  @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
  @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private Date participateEndTime;

  /** 参与范围 ScanActivityScopeEnum */
  @ApiModelProperty("参与范围,all-全部,part-部分,special-指定,如果是消费者默认传all")
  private String participateScope;

  /** 物料范围 ScanActivityScopeEnum */
  @ApiModelProperty("物料范围,part-部分,special-指定")
  private String productScope;

  /** 红包发放账号编码 */
  @ApiModelProperty("红包发放账号编码")
  private String accountCode;

  /** 活动状态 ScanActivityStatusEnum */
  @ApiModelProperty("活动状态,default-待开始,running-进行中,finish-已结束")
  private String actStatus;

  /** 数据业务状态（启用状态） */
  @ApiModelProperty("启用状态,-启用,-禁用")
  private String enableStatus;

  /** 参与范围配置信息 */
  @ApiModelProperty("参与范围配置信息")
  private List<ScanActivityParticipateScopeDto> participateScopeList;

  /** 物料范围配置 */
  @ApiModelProperty("物料范围配置")
  private List<ScanActivityProductScopeDto> productList;

  /** 活动规则 */
  @ApiModelProperty("活动规则")
  private List<ScanActivityRewardDto> rewardList;

  /** 红包发放的充值账户信息 */
  @ApiModelProperty("红包发放的充值账户信息")
  private ScanActivityRewardAccountDto account;

  /** 是否限制消费者扫码区域 */
  @ApiModelProperty("是否限制消费者扫码区域")
  private Boolean areaFlag;

  /** 消费者扫码活动参与范围 */
  @ApiModelProperty("消费者扫码活动参与范围")
  private List<ScanActivityUserAreaDto> areaList;

  /** 活动描述 */
  @ApiModelProperty("活动描述")
  private String remark;
}
