package com.biz.crm.cps.business.activity.scan.sdk.dto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * 扫码活动前端分页列表查询dto
 *
 * @author sunx
 * @date 2022/3/28
 */
@Data
@ApiModel(value = "ScanActivityListPaginationDto", description = "扫码活动前端分页列表查询dto")
public class ScanActivityListPaginationDto {

  /** 活动名称 */
  @ApiModelProperty("活动名称")
  private String name;

  /** 参与对象 ScanActivityParticipateObjEnum */
  @ApiModelProperty("参与对象,customer-经销商,terminal-终端")
  private String participateObj;

  /** 参与对象编码 */
  @ApiModelProperty("参与对象编码,经销商编码,终端编码，导购编码，消费者编码")
  private String participateCode;

  /** 活动参与状态 ScanParticipateStatusEnum */
  @ApiModelProperty("活动参与状态,default-待参与,participate-已参与,overdue-已过期")
  private String participateStatus;
}
