package com.biz.crm.cps.business.activity.scan.sdk.dto;

import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Date;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

/**
 * 扫码活动分页查询dto
 *
 * @author sunx
 * @date 2022-02-16 16:40:07
 */
@Data
@ApiModel(value = "ScanActivityPaginationDto", description = "扫码活动分页查询dto")
public class ScanActivityPaginationDto {

  /** 活动编码 */
  @ApiModelProperty("活动编码")
  private String code;

  /** 活动名称 */
  @ApiModelProperty("活动名称")
  private String name;

  /** 参与对象 */
  @ApiModelProperty("参与对象")
  private String participateObj;

  /** 数据业务状态（启用状态） */
  @ApiModelProperty("启用状态")
  private String enableStatus;

  /** 活动状态 */
  @ApiModelProperty("活动状态")
  private String actStatus;

  /** 创建开始时间 */
  @ApiModelProperty("创建开始时间")
  @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
  @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private Date createStartTime;

  /** 创建结束时间 */
  @ApiModelProperty("创建结束时间")
  @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
  @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private Date createEndTime;
}
