package com.biz.crm.cps.business.activity.scan.sdk.dto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * 扫码活动参与范围配置dto
 *
 * @author sunx
 * @date 2022/2/22
 */
@Data
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "扫码活动参与范围配置dto")
public class ScanActivityParticipateScopeDto {
  /** 参与范围类型 */
  @ApiModelProperty(
      "参与范围类型,"
          + "经销商(组织-org、渠道-channel、标签-tag、经销商-default)"
          + "终端(组织-org、渠道-channel、标签-tag、终端-default)"
          + "导购(组织-org、职位级别-position、导购-default)"
          + "消费者(消费者-default)")
  private String participateScopeType;
  /** 关联业务编码 */
  @ApiModelProperty("关联业务编码")
  private String relateCode;
  /** 关联业务描述 */
  @ApiModelProperty("关联业务描述")
  private String relateName;
  /** 排序 */
  @ApiModelProperty("排序")
  private Integer sort;
}
