package com.biz.crm.cps.business.activity.scan.sdk.dto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * 扫码活动物料范围配置信息dto
 *
 * @author sunx
 * @date 2022-02-16 16:40:09
 */
@Data
@ApiModel(value = "ScanActivityProductScopeDto", description = "扫码活动物料范围配置信息dto")
public class ScanActivityProductScopeDto {

  /** 活动编码 */
  @ApiModelProperty("活动编码")
  private String actCode;

  /** 范围类型 cps-product-level数据字典 */
  @ApiModelProperty("范围类型，cps-product-level数据字典")
  private String scopeType;

  /** 关联物料业务编码 */
  @ApiModelProperty("关联物料业务编码")
  private String relateCode;

  /** 关联业务描述 */
  @ApiModelProperty("关联业务描述")
  private String relateName;

  /** 排序 */
  @ApiModelProperty("排序")
  private Integer sort;
}
