package com.biz.crm.cps.business.activity.scan.sdk.dto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * 获取用户已参与且当前正在执行的扫码活动编码入参dto
 *
 * @author sunx
 * @date 2022/3/8
 */
@Data
@ApiModel(value = "ScanActivityQueryDto", description = "获取用户已参与且当前正在执行的扫码活动编码入参dto")
public class ScanActivityQueryDto {

  /** 参与对象 ScanActivityParticipateObjEnum */
  @ApiModelProperty("参与对象")
  private String participateObj;

  /** 参与对象编码 */
  @ApiModelProperty("参与对象编码")
  private String userCode;

  /** 物料编码 */
  @ApiModelProperty("物料编码")
  private String materialCode;

  /** 省 - 消费者扫码时 */
  @ApiModelProperty("省")
  private String provinceName;

  /** 市 - 消费者扫码时 */
  @ApiModelProperty("市")
  private String cityName;
}
