package com.biz.crm.cps.business.activity.scan.sdk.dto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.List;
import lombok.Data;

/**
 * 扫码活动奖励规则dto
 *
 * @author sunx
 * @date 2022-02-16 16:40:13
 */
@Data
@ApiModel(value = "ScanActivityRewardDto", description = "扫码活动奖励规则dto")
public class ScanActivityRewardDto {

  /** 活动编码 */
  @ApiModelProperty("活动编码")
  private String actCode;

  /** 类型-瓶码、箱码等 ScanActivityRewardScanTypeEnum */
  @ApiModelProperty("类型-box-箱码,pack-盒码,lib-盖内码")
  private String type;

  /** 奖励类型 ScanActivityRewardTypeEnum */
  @ApiModelProperty("奖励类型，red_packet-红包，point-积分，fee-费用")
  private String rewardType;

  /** 是否随机 */
  @ApiModelProperty("是否随机")
  private Boolean randomFlag;

  /** 规则编码 */
  @ApiModelProperty("规则编码")
  private String rewardCode;

  /** 排序 */
  @ApiModelProperty("排序")
  private Integer sort;

  /** 配置明细 */
  @ApiModelProperty("配置明细")
  private List<ScanActivityRewardValueDto> valueList;

  /** 返利明细 */
  @ApiModelProperty("返利明细")
  private List<ScanActivityRebateDto> rebateList;
}
