package com.biz.crm.cps.business.activity.scan.sdk.dto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.math.BigDecimal;
import lombok.Data;

/**
 * 扫码活动奖励发放值概率配置信息dto
 *
 * @author sunx
 * @date 2022-02-16 16:44:35
 */
@Data
@ApiModel(value = "ScanActivityRewardValueDto", description = "扫码活动奖励发放值概率配置信息dto")
public class ScanActivityRewardValueDto {

  /** 活动编码 */
  @ApiModelProperty("活动编码")
  private String actCode;

  /** 奖励配置编码 */
  @ApiModelProperty("奖励配置编码")
  private String rewardCode;

  /** 概率 */
  @ApiModelProperty("概率")
  private BigDecimal rate;

  /** 奖励值 */
  @ApiModelProperty("奖励值")
  private BigDecimal rewardValue;

  /** 排序 */
  @ApiModelProperty("排序")
  private Integer sort;
}
